% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confirm_ptp.R
\name{calculate_confirm_2015_num_of_rf}
\alias{calculate_confirm_2015_num_of_rf}
\title{Calculate Number Of Risk Factors (CONFIRM 2015)}
\usage{
calculate_confirm_2015_num_of_rf(
  have_typical_chest_pain,
  have_diabetes,
  have_hypertension,
  have_family_history,
  is_current_smoker,
  max_na = 0,
  label_have_typical_chest_pain_no = c("no"),
  label_have_typical_chest_pain_yes = c("yes"),
  label_have_typical_chest_pain_unknown = c(NA, NaN),
  label_have_diabetes_no = c("no"),
  label_have_diabetes_yes = c("yes"),
  label_have_diabetes_unknown = c(NA, NaN),
  label_have_hypertension_no = c("no"),
  label_have_hypertension_yes = c("yes"),
  label_have_hypertension_unknown = c(NA, NaN),
  label_have_family_history_no = c("no"),
  label_have_family_history_yes = c("yes"),
  label_have_family_history_unknown = c(NA, NaN),
  label_is_current_smoker_no = c("no"),
  label_is_current_smoker_yes = c("yes"),
  label_is_current_smoker_unknown = c(NA, NaN),
  error_call = rlang::caller_env()
)
}
\arguments{
\item{have_typical_chest_pain}{The value of variable in the parameters
\code{label_have_typical_chest_pain_no}, \code{label_have_typical_chest_pain_yes}
and \code{label_have_typical_chest_pain_unknown}.}

\item{have_diabetes}{The value of variable in the parameters
\code{label_have_diabetes_no}, \code{label_have_diabetes_yes}
and \code{label_have_diabetes_unknown}.}

\item{have_hypertension}{The value of variable in the parameters
\code{label_have_hypertension_no}, \code{label_have_hypertension_yes}
and \code{label_have_hypertension_unknown}.}

\item{have_family_history}{The value of variable in the parameters
\code{label_have_family_history_no}, \code{label_have_family_history_yes}
and \code{label_have_family_history_unknown}.}

\item{is_current_smoker}{The value of variable in the parameters
\code{label_is_current_smoker_no}, \code{label_is_current_smoker_yes}
and \code{label_is_current_smoker_unknown}.}

\item{max_na}{Input integer 0 to 5 to indicate the maximum number of
missing risk factors to tolerate before outputting an \code{NA}.
Default: 0}

\item{label_have_typical_chest_pain_no}{Label(s) for patient not having
typical chest pain symptom.
Default: \code{c("no")}}

\item{label_have_typical_chest_pain_yes}{Label(s) for patient having
typical chest pain symptom.
Default: \code{c("yes")}}

\item{label_have_typical_chest_pain_unknown}{Label(s) for patient having unknown
typical chest pain symptom.}

\item{label_have_diabetes_no}{Label(s) for patient with no diabetes.
Default: \code{c("no")}}

\item{label_have_diabetes_yes}{Label(s) for patient having diabetes.
Default: \code{c("yes")}}

\item{label_have_diabetes_unknown}{Label(s) for patient
having unknown diabetes.
Default: \code{c(NA, NaN)}}

\item{label_have_hypertension_no}{Label(s) for patient with no hypertension.
Default: \code{c("no")}}

\item{label_have_hypertension_yes}{Label(s) for patient having hypertension.
Default: \code{c("yes")}}

\item{label_have_hypertension_unknown}{Label(s) for patient
having unknown hypertension.
Default: \code{c(NA, NaN)}}

\item{label_have_family_history_no}{Label(s) for patient with no family history of CAD.
Default: \code{c("no")}}

\item{label_have_family_history_yes}{Label(s) for patient having family history of CAD.
Default: \code{c("yes")}}

\item{label_have_family_history_unknown}{Label(s) for patient
having unknown family history of CAD.
Default: \code{c(NA, NaN)}}

\item{label_is_current_smoker_no}{Label(s) for patients who are not current smokers.
Default: \code{c("no")}}

\item{label_is_current_smoker_yes}{Label(s) for patients who are current smokers.
Default: \code{c("yes")}}

\item{label_is_current_smoker_unknown}{Label(s) for patient with unknown smoking status.}

\item{error_call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\value{
An integer indicating the number of risk factors the patient has.
It can also be \code{NA} if the number of missing risk factors exceeds the \code{max_na}
input value
}
\description{
A function used to calculate the number of
risk factors the patient has. This is used to calculate the pretest
probability of coronary artery disease (CAD) based on the
2015 CONFIRM Risk Score.
}
\examples{
calculate_confirm_2015_num_of_rf(
  have_typical_chest_pain = "yes",
  have_diabetes = "yes",
  have_hypertension = "yes",
  have_family_history = "yes",
  is_current_smoker = "no"
)

calculate_confirm_2015_num_of_rf(
  have_typical_chest_pain = "no",
  have_diabetes = "no",
  have_hypertension = "no",
  have_family_history = NA,
  is_current_smoker = "no",
  max_na = 0
)

calculate_confirm_2015_num_of_rf(
  have_typical_chest_pain = "no",
  have_diabetes = "no",
  have_hypertension = "no",
  have_family_history = NA,
  is_current_smoker = "no",
  max_na = 1
)
}
