% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcs_ptp.R
\name{calculate_dcs_1993_severe_cad_ptp}
\alias{calculate_dcs_1993_severe_cad_ptp}
\title{Calculate 1993 Duke Clinical Score for Severe CAD}
\usage{
calculate_dcs_1993_severe_cad_ptp(
  age,
  sex,
  chest_pain_type,
  have_progressive_angina,
  have_nocturnal_angina,
  have_peripheral_vascular_disease,
  have_cerebrovascular_disease,
  have_carotid_bruits,
  have_hypertension,
  have_dyslipidemia,
  have_diabetes,
  have_q_waves,
  have_st_t_changes,
  frequency_of_angina_pain_per_week,
  duration_of_cad_symptoms_year,
  max_na_risk_factor_index = 0,
  max_na_pain_index = 0,
  max_na_vascular_disease_index = 0,
  max_frequency_of_angina_pain_per_week = 35,
  label_sex_male = c("male"),
  label_sex_female = c("female"),
  label_sex_unknown = c(NA, NaN),
  label_cpt_nonanginal = c("nonanginal"),
  label_cpt_atypical = c("atypical"),
  label_cpt_typical = c("typical"),
  label_cpt_unknown = c(NA, NaN),
  label_have_progressive_angina_no = c("no"),
  label_have_progressive_angina_yes = c("yes"),
  label_have_progressive_angina_unknown = c(NA, NaN),
  label_have_nocturnal_angina_no = c("no"),
  label_have_nocturnal_angina_yes = c("yes"),
  label_have_nocturnal_angina_unknown = c(NA, NaN),
  label_have_pvd_no = c("no"),
  label_have_pvd_yes = c("yes"),
  label_have_pvd_unknown = c(NA, NaN),
  label_have_cvd_no = c("no"),
  label_have_cvd_yes = c("yes"),
  label_have_cvd_unknown = c(NA, NaN),
  label_have_carotid_bruits_no = c("no"),
  label_have_carotid_bruits_yes = c("yes"),
  label_have_carotid_bruits_unknown = c(NA, NaN),
  label_have_hypertension_no = c("no"),
  label_have_hypertension_yes = c("yes"),
  label_have_hypertension_unknown = c(NA, NaN),
  label_have_dyslipidemia_no = c("no"),
  label_have_dyslipidemia_yes = c("yes"),
  label_have_dyslipidemia_unknown = c(NA, NaN),
  label_have_diabetes_no = c("no"),
  label_have_diabetes_yes = c("yes"),
  label_have_diabetes_unknown = c(NA, NaN),
  label_have_q_waves_no = c("no"),
  label_have_q_waves_yes = c("yes"),
  label_have_q_waves_unknown = c(NA, NaN),
  label_have_st_t_changes_no = c("no"),
  label_have_st_t_changes_yes = c("yes"),
  label_have_st_t_changes_unknown = c(NA, NaN)
)
}
\arguments{
\item{age}{Input numeric value to indicate the age of the patient in years.}

\item{sex}{The value of variable in the parameters \code{label_sex_male},
\code{label_sex_female} and \code{label_sex_unknown}.}

\item{chest_pain_type}{The value of variable in the parameters,
\code{label_cpt_nonanginal}, \code{label_cpt_atypical}, \code{label_cpt_typical} and
\code{label_cpt_unknown}.}

\item{have_progressive_angina}{The value of variable in the parameters
\code{label_have_progressive_angina_no}, \code{label_have_progressive_angina_yes}
and \code{label_have_progressive_angina_unknown}.}

\item{have_nocturnal_angina}{The value of variable in the parameters
\code{label_have_nocturnal_angina_no}, \code{label_have_nocturnal_angina_yes}
and \code{label_have_nocturnal_angina_unknown}.}

\item{have_peripheral_vascular_disease}{The value of variable in the parameters
\code{label_have_pvd_no}, \code{label_have_pvd_yes}
and \code{label_have_pvd_unknown}.}

\item{have_cerebrovascular_disease}{The value of variable in the parameters
\code{label_have_cvd_no}, \code{label_have_cvd_yes}
and \code{label_have_cvd_unknown}.}

\item{have_carotid_bruits}{The value of variable in the parameters
\code{label_have_carotid_bruits_no}, \code{label_have_carotid_bruits_yes}
and \code{label_have_carotid_bruits_unknown}.}

\item{have_hypertension}{The value of variable in the parameters
\code{label_have_hypertension_no}, \code{label_have_hypertension_yes}
and \code{label_have_hypertension_unknown}.}

\item{have_dyslipidemia}{The value of variable in the parameters
\code{label_have_dyslipidemia_no}, \code{label_have_dyslipidemia_yes}
and \code{label_have_dyslipidemia_unknown}.}

\item{have_diabetes}{The value of variable in the parameters
\code{label_have_diabetes_no}, \code{label_have_diabetes_yes}
and \code{label_have_diabetes_unknown}.}

\item{have_q_waves}{The value of variable in the parameters
\code{label_have_q_waves_no}, \code{label_have_q_waves_yes}
and \code{label_have_q_waves_unknown}.}

\item{have_st_t_changes}{The value of variable in the parameters
\code{label_have_st_t_changes_no}, \code{label_have_st_t_changes_yes}
and \code{label_have_st_t_changes_unknown}.}

\item{frequency_of_angina_pain_per_week}{Input integer to indicate the patient's
frequency of angina per week.}

\item{duration_of_cad_symptoms_year}{Input integer to indicate the duration of
coronary artery disease symptoms in years.}

\item{max_na_risk_factor_index}{Input integer 0 to 3 to indicate the maximum number of
missing risk factors to tolerate before outputting an \code{NA}.
Default: 0}

\item{max_na_pain_index}{Input integer 0 to 5 to indicate the maximum number of
missing symptoms to tolerate before outputting an \code{NA}.
Default: 0}

\item{max_na_vascular_disease_index}{Input integer 0 to 3 to indicate the maximum number of
missing disease history to tolerate before outputting an \code{NA}.
Default: 0}

\item{max_frequency_of_angina_pain_per_week}{Input non-negative integer to
indicate the maximum frequency angina per week to tolerate before outputting an \code{NA}.
In the Duke Clinical Score 1993 paper, the maximum value is set as 35.
Default: 35}

\item{label_sex_male}{Label(s) for definition(s) of male sex.
Default: \code{c("male")}}

\item{label_sex_female}{Label(s) for definition(s) of female sex.
Default: \code{c("female")}}

\item{label_sex_unknown}{Label(s) for definition(s) of missing sex.
Default: \code{c(NA, NaN)}}

\item{label_cpt_nonanginal}{Label(s) for patient having nonanginal or non-specific chest pain.
Default: \code{c("nonanginal")}}

\item{label_cpt_atypical}{Label(s) for patient having atypical chest pain.
Default: \code{c("atypical")}}

\item{label_cpt_typical}{Label(s) for patient having typical chest pain.
Default: \code{c("typical")}}

\item{label_cpt_unknown}{Label(s) for patient having unknown chest pain type symptoms.
Default: \code{c(NA, NaN)}}

\item{label_have_progressive_angina_no}{Label(s) for patient not having progressive angina.
Default: \code{c("no")}}

\item{label_have_progressive_angina_yes}{Label(s) for patient having progressive angina.
Default: \code{c("yes")}}

\item{label_have_progressive_angina_unknown}{Label(s) for patient
having unknown progressive angina.
Default: \code{c(NA, NaN)}}

\item{label_have_nocturnal_angina_no}{Label(s) for patient not having nocturnal angina.
Default: \code{c("no")}}

\item{label_have_nocturnal_angina_yes}{Label(s) for patient having nocturnal angina.
Default: \code{c("yes")}}

\item{label_have_nocturnal_angina_unknown}{Label(s) for patient
having unknown nocturnal angina.
Default: \code{c(NA, NaN)}}

\item{label_have_pvd_no}{Label(s) for patient not having peripheral vascular disease.
Default: \code{c("no")}}

\item{label_have_pvd_yes}{Label(s) for patient having peripheral vascular disease.
Default: \code{c("yes")}}

\item{label_have_pvd_unknown}{Label(s) for patient
having unknown peripheral vascular disease.
Default: \code{c(NA, NaN)}}

\item{label_have_cvd_no}{Label(s) for patient not having cerebrovascular disease.
Default: \code{c("no")}}

\item{label_have_cvd_yes}{Label(s) for patient having cerebrovascular disease.
Default: \code{c("yes")}}

\item{label_have_cvd_unknown}{Label(s) for patient
having unknown cerebrovascular disease.
Default: \code{c(NA, NaN)}}

\item{label_have_carotid_bruits_no}{Label(s) for patient not having carotid bruits.
Default: \code{c("no")}}

\item{label_have_carotid_bruits_yes}{Label(s) for patient having carotid bruits.
Default: \code{c("yes")}}

\item{label_have_carotid_bruits_unknown}{Label(s) for patient
having unknown carotid bruits.
Default: \code{c(NA, NaN)}}

\item{label_have_hypertension_no}{Label(s) for patient with no hypertension.
Default: \code{c("no")}}

\item{label_have_hypertension_yes}{Label(s) for patient having hypertension.
Default: \code{c("yes")}}

\item{label_have_hypertension_unknown}{Label(s) for patient
having unknown hypertension.
Default: \code{c(NA, NaN)}}

\item{label_have_dyslipidemia_no}{Label(s) for patient with no dyslipidemia.
Default: \code{c("no")}}

\item{label_have_dyslipidemia_yes}{Label(s) for patient having dyslipidemia.
Default: \code{c("yes")}}

\item{label_have_dyslipidemia_unknown}{Label(s) for patient
having unknown dyslipidemia.
Default: \code{c(NA, NaN)}}

\item{label_have_diabetes_no}{Label(s) for patient with no diabetes.
Default: \code{c("no")}}

\item{label_have_diabetes_yes}{Label(s) for patient having diabetes.
Default: \code{c("yes")}}

\item{label_have_diabetes_unknown}{Label(s) for patient
having unknown diabetes.
Default: \code{c(NA, NaN)}}

\item{label_have_q_waves_no}{Label(s) for patient not having Q waves on ECG.
Default: \code{c("no")}}

\item{label_have_q_waves_yes}{Label(s) for patient having Q waves on ECG.
Default: \code{c("yes")}}

\item{label_have_q_waves_unknown}{Label(s) for patient with unknown Q waves on ECG.
Default: \code{c(NA, NaN)}}

\item{label_have_st_t_changes_no}{Label(s) for patient not having ST-T changes on ECG.
Default: \code{c("no")}}

\item{label_have_st_t_changes_yes}{Label(s) for patient having ST-T changes on ECG.
Default: \code{c("yes")}}

\item{label_have_st_t_changes_unknown}{Label(s) for patient with unknown ST-T changes on ECG.
Default: \code{c(NA, NaN)}}
}
\value{
A numeric value representing the patient's PTP for severe
(>75\% luminal diameter narrowing of all three major coronary arteries
or of the left main coronary artery) CAD
based on the 1993 Duke Clinical Score.
}
\description{
This function returns a patient's
pre-test probability (PTP) of severe (>75\% luminal diameter narrowing
of all three major coronary arteries or of the left main coronary artery)
coronary artery disease based on the
1993 Duke Clinical Score.
}
\details{
The predictive model is based on
patients referred for cardiac catheterisation between 1969 and 1983.
}
\examples{
# 40 year old female with typical chest pain for one year,
# She has progressive angina but no nocturnal angina.
# Angina pain lasted at most five times a week.
# She has peripheral vascular and cerebrovascular disease.
# She has hypertension but has no dyslipidemia and not diabetic.
# She has Q waves and ST-T changes on ECG.

calculate_dcs_1993_severe_cad_ptp(
    age = 40,
    sex = "female",
    chest_pain_type = "typical",
    have_progressive_angina = "yes",
    have_nocturnal_angina = "no",
    have_peripheral_vascular_disease = "yes",
    have_cerebrovascular_disease = "yes",
    have_carotid_bruits = "no",
    have_hypertension = "yes",
    have_dyslipidemia = "no",
    have_diabetes = "no",
    have_q_waves = "yes",
    have_st_t_changes = "yes",
    frequency_of_angina_pain_per_week = 5,
    duration_of_cad_symptoms_year = 1,
)
}
