% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/harmonise.R
\name{harmonise_two_labels}
\alias{harmonise_two_labels}
\title{Harmonise Two Labels}
\usage{
harmonise_two_labels(
  arg,
  label_one,
  label_two,
  label_unknown,
  harmonise_label_one = "no",
  harmonise_label_two = "yes",
  harmonise_label_unknown = NA,
  error_call = rlang::caller_env()
)
}
\arguments{
\item{arg}{Input argument, in characters to be harmonised}

\item{label_one}{Input character vector representing the ways to identify \code{harmonise_label_one}}

\item{label_two}{Input character vector representing the ways to identify \code{harmonise_label_two}}

\item{label_unknown}{Input character vector representing the ways to identify \code{harmonise_label_unknown}}

\item{harmonise_label_one}{Input character representing the harmonised label for \code{label_one}
Default: 'group_1'}

\item{harmonise_label_two}{Input character representing the harmonised label for \code{label_two}
Default: 'group_2'}

\item{harmonise_label_unknown}{Input character representing the harmonised label for \code{label_unknown}
Default: NA}

\item{error_call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\value{
Character representing one of the two standardise labels.
}
\description{
Function to map an input from
two different list into one of the two standardise labels
}
\examples{
label_have_dyspnoea_no <- c("no", "No")
label_have_dyspnoea_yes <- c("yes", "Yes")
label_have_dyspnoea_unknown <- c(NA, NaN)

# Gives harmonise_label_one if there is valid input of have_dyspnoea
have_dyspnoea <- "No"

harmonise_two_labels(
  arg = have_dyspnoea,
  label_one = label_have_dyspnoea_no,
  label_two = label_have_dyspnoea_yes,
  label_unknown = label_have_dyspnoea_unknown,
  harmonise_label_one = "no",
  harmonise_label_two = "yes",
  harmonise_label_unknown = NA
)

# Gives harmonise_label_two if there is valid input of have_dyspnoea
have_dyspnoea <- "Yes"

harmonise_two_labels(
  arg = have_dyspnoea,
  label_one = label_have_dyspnoea_no,
  label_two = label_have_dyspnoea_yes,
  label_unknown = label_have_dyspnoea_unknown,
  harmonise_label_one = "no",
  harmonise_label_two = "yes",
  harmonise_label_unknown = NA
)

# Gives harmonise_label_unknown if there is valid missing input of have_dyspnoea
have_dyspnoea <- NaN

harmonise_two_labels(
  arg = have_dyspnoea,
  label_one = label_have_dyspnoea_no,
  label_two = label_have_dyspnoea_yes,
  label_unknown = label_have_dyspnoea_unknown,
  harmonise_label_one = "no",
  harmonise_label_two = "yes",
  harmonise_label_unknown = NA
)

# Gives harmonise_label_unknown if there is valid missing input of have_dyspnoea
have_dyspnoea <- "NIL"
label_have_dyspnoea_unknown <- c("NIL")

harmonise_two_labels(
  arg = have_dyspnoea,
  label_one = label_have_dyspnoea_no,
  label_two = label_have_dyspnoea_yes,
  label_unknown = label_have_dyspnoea_unknown,
  harmonise_label_one = "no",
  harmonise_label_two = "yes",
  harmonise_label_unknown = NA
)

# Gives error of invalid have_dyspnoea input with partial match
have_dyspnoea <- "Not"
label_have_dyspnoea_unknown <- c(NA, NaN)

try(harmonise_two_labels(
   arg = have_dyspnoea,
   label_one = label_have_dyspnoea_no,
   label_two = label_have_dyspnoea_yes,
   label_unknown = label_have_dyspnoea_unknown,
   harmonise_label_one = "no",
   harmonise_label_two = "yes",
   harmonise_label_unknown = NA
))

# Gives error of invalid have_dyspnoea input without partial match
have_dyspnoea <- "Something"
label_have_dyspnoea_unknown <- c(NA, NaN)

try(harmonise_two_labels(
   arg = have_dyspnoea,
   label_one = label_have_dyspnoea_no,
   label_two = label_have_dyspnoea_yes,
   label_unknown = label_have_dyspnoea_unknown,
   harmonise_label_one = "no",
   harmonise_label_two = "yes",
   harmonise_label_unknown = NA
))

# Gives error of invalid missing input of have_dyspnoea
have_dyspnoea <- NA
label_have_dyspnoea_unknown <- c("NIL")

try(harmonise_two_labels(
   arg = have_dyspnoea,
   label_one = label_have_dyspnoea_no,
   label_two = label_have_dyspnoea_yes,
   label_unknown = label_have_dyspnoea_unknown,
   harmonise_label_one = "no",
   harmonise_label_two = "yes",
   harmonise_label_unknown = NA
))


}
