% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/primer-package.R
\docType{data}
\name{weeds}
\alias{weeds}
\title{Percent cover of six perennial herbaceous plants}
\format{
A data frame with 15140 observations on the following 8 variables.
\describe{ \item{X}{a numeric vector} \item{Genus}{a factor
with levels \code{Aster}, \code{Euthamia}, \code{Solidago}}
\item{Epithet}{a factor with levels \code{canadensis},
\code{gigantea}, \code{graminifolia}, \code{novae-angliae}, \code{pilosus},
\code{rugosa}} \item{FieldName}{a factor with levels \code{C3,}
\code{C4}, \code{C5}, \code{C6}, \code{C7}, \code{D1}, \code{D2}, \code{D3},
\code{E1}, \code{E2}} \item{Age}{a numeric vector indicating the
number of years of succession, since abandonment from agriculture.}
\item{PlotId}{a numeric vector} \item{Cover}{a numeric
vector; percent cover, estimated visually.} \item{Species}{a factor
with levels \code{A.novae-angliae}, \code{A.pilosus}, \code{E.graminifolia},
\code{S.canadensis}, \code{S.gigantea}, \code{S.rugosa}} }
}
\source{
Data graciously provided by Scott Meiners (Eastern Illinois
University, http://www.ecostudies.org/bss/).
}
\description{
Percent cover of six of the most common herbaceous perennial species from
the Buell-Small long term succession study (http://www.ecostudies.org/bss/).
Data are plot-level visual estimates of percent cover.
}
\examples{

data(weeds)
str(weeds);
# lattice::xyplot(Cover ~ Age, data=weeds, groups=Species,
# type=c("a"), auto.key=list(lines=TRUE, points=FALSE, columns=3),
# ylim=c(-1,20))

}
\references{
Stevens, M.H.H. (2009) \emph{A Primer of Ecology with R}. Use R!
Series. Springer.
}
\keyword{datasets}
