% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_ttest.R
\name{print_ttest}
\alias{print_ttest}
\title{Print the results of a t-test}
\usage{
print_ttest(
  t_object,
  d_object = NULL,
  decimals = 2,
  decimals_p = 3,
  confidence = FALSE
)
}
\arguments{
\item{t_object}{An object of class "htest" returned by
\code{\link{t.test}}.}

\item{d_object}{An effect size table returned by
\code{\link[effectsize]{cohens_d}} from package \code{effectsize}.
Optional argument.}

\item{decimals}{How many decimals should be printed for the t-value
(defaults to 2).}

\item{decimals_p}{How many decimals should be printed for the p-value
(defaults to 3).}

\item{confidence}{Logical. Whether a confidence interval for the effectsize
should be printed or not. Can only be \code{TRUE} if \code{d_object} is
provided.}
}
\value{
A string describing the t-test; to be
included in an R markdown document.
}
\description{
Print the results of a t-test
}
\details{
To use this function, you need to install the R package \code{effectsize}
to compute Cohen's d; pass this object as the second argument.
}
\examples{

ttest <- t.test(1:10, y = c(7:20), var.equal = TRUE)
library("effectsize") # for Cohen's d
cohend <- cohens_d(1:10, c(7:20))
print_ttest(ttest, cohend) # include this call in Rmd inline code

# An example for paired data:
data(sleep) # ?sleep
tt <- t.test(sleep$extra[sleep$group == 1], 
             sleep$extra[sleep$group == 2], paired = TRUE)
cd <- cohens_d(sleep$extra[sleep$group == 1], 
               sleep$extra[sleep$group == 2], paired = TRUE)
print_ttest(tt, cd)
# Print the confidence interval
print_ttest(tt, cd, confidence = TRUE)
# The information about the CI is taken from the effectsize object:
cd <- cohens_d(sleep$extra[sleep$group == 1], 
               sleep$extra[sleep$group == 2], paired = TRUE, ci = .8)
print_ttest(tt, cd, confidence = TRUE)
# effect size object can be left out:
print_ttest(tt)

}
\references{
Cohen, J. (1988). Statistical power analysis for the behavioral sciences
(2nd ed.). Hillsale, NJ: Lawrence Erlbaum.
}
\author{
Martin Papenberg \email{martin.papenberg@hhu.de}
}
