% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probe_wrapper.R
\name{probe}
\alias{probe}
\title{Fitting PaRtitiOned empirical Bayes Ecm (PROBE) algorithm to sparse high-dimensional linear models.}
\usage{
probe(Y, X, Z = NULL, ep = 0.1, maxit = 10000, Y_test = NULL, X_test = NULL, 
Z_test = NULL, verbose = FALSE, signal = NULL, eta_i = NULL, alpha = 0.05, 
plot_ind = FALSE, adj = 5)
}
\arguments{
\item{Y}{The outcome variable.}

\item{X}{An \code{n x M} matrix of sparse predictors variables.}

\item{Z}{(optional) An \code{n x p} matrix or dataframe of other predictors not subjected to the sparsity assumption.}

\item{ep}{Value against which to compare convergence criterion (default = 0.1).}

\item{maxit}{Maximum number of iterations the algorithm will run for (default = 10000).}

\item{Y_test}{(optional) Test Y data used plotting purposes only (doesn't impact results).}

\item{X_test}{(optional) Test X data used plotting purposes only (doesn't impact results).}

\item{Z_test}{(optional) Test Z data used plotting purposes only (doesn't impact results).}

\item{verbose}{A logical (true/false) value whether to print algorithm iteration progress and summary quantities (default = FALSE).}

\item{signal}{(optional) A vector of indicies of the true non-null coefficients. This is used to calculate the true and false discovery rates by iteration for simulated data. Used plotting purposes only (doesn't impact results).}

\item{eta_i}{(optional) A vector of the true signal. This is used to calculate the MSE by iteration for simulated data. Used plotting purposes only (doesn't impact results).}

\item{alpha}{(optional) significance level}

\item{plot_ind}{A logical values (True/False) for whether to output plots on algorithm results and progress (default = FALSE)}

\item{adj}{Bandwidth parameter for empirical Bayes E-step. The bandwidth will be equal to \code{adj} times Silverman's 'rule of thumb' (default = 2).}
}
\value{
A list including 

\code{beta_ast_hat} MAP estimates of the regression coefficients (\eqn{\beta^\ast}),

\code{beta_hat, beta_hat_var} MAP estimates of the posterior expectation (beta_hat) and variance (beta_hat_var) of the prior mean (\eqn{\beta}) of the regression coefficients assuming \eqn{\gamma=1}, 

\code{gamma_hat} the posterior expectation of the latent \eqn{\gamma} variables, 

\code{sigma2_est} MAP estimate of the residual variance, 

\code{E_step} full results of the final E_step, 

\code{Calb_mod} results of first (\eqn{\alpha_0}) part of the M-step,  

\code{count} the total number of iterations before convergence.
}
\description{
A wrapper function for the all-at-once variant of the PROBE algorithm.
}
\examples{
### Example
data(Sim_data)
data(Sim_data_test)
attach(Sim_data)
attach(Sim_data_test)
alpha <- 0.05
plot_ind <- TRUE
adj <- 10

# Run the analysis. Y_test and X_test are included for plotting purposes only
full_res <- probe( Y = Y, X = X, Y_test = Y_test, 
X_test = X_test, alpha = alpha, plot_ind = plot_ind, adj = adj)

# Predicting for test data
pred_res <- predict_probe_func(full_res, X = X_test)
sqrt(mean((Y_test - pred_res$Pred)^2))

# Estimate of the residual variance and true value
full_res$sigma2_est
sigma2_tr

# RMSE of estimated beta coefficients
beta_ast_est <- full_res$beta_ast_hat
sqrt(mean((beta_ast_est - beta_tr)^2))

# Posterior expectation of gamma by true
gamma_est <- full_res$E_step$gamma
sum(gamma_est)
sum(gamma_est[beta_tr>0])

### Examples that incorporate additional covariate data (Z) 
### not subjected to the sparsity assumption available on Github.


}
\references{
McLain, A. C., Zgodic, A., & Bondell, H. (2022). Sparse high-dimensional linear regression with a partitioned empirical Bayes ECM algorithm. arXiv preprint arXiv:2209.08139..
}
\seealso{
predict_probe_func to obtain predictions, credible intervals and prediction intervals from PROBE.
}
