% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outcome_bin_logistic.R
\docType{class}
\name{OutcomeBinaryLogistic-class}
\alias{OutcomeBinaryLogistic-class}
\alias{.outcome_bin_logistic}
\title{\code{OutcomeBinaryLogistic} class}
\description{
A class for defining a logistic regression with a binary outcome
to be translated to Stan code.
Objects of class \code{OutcomeBinaryLogistic} should not be created directly but by
the constructor \code{\link[=outcome_bin_logistic]{outcome_bin_logistic()}}.
}
\section{Slots}{

\describe{
\item{\code{n_param}}{integer. Number of ancillary parameters for the model to estimate (0).}

\item{\code{param_priors}}{list. Named list of prior distributions on the ancillary parameters in the model.
Empty for \code{OutcomeBinaryLogistic}.}

\item{\code{binary_var}}{character. Variable used for outcome in \code{OutcomeBinaryLogistic} objects.}

\item{\code{baseline_prior}}{\code{Prior}. Object of class \code{Prior}
specifying prior distribution for the baseline outcome.}

\item{\code{name_beta_trt.}}{Named vector for beta_trt.}

\item{\code{name_exp_trt.}}{Named vector for exponentiated beta_trt}

\item{\code{alpha_type.}}{How to interpret alpha.}

\item{\code{name_addnl_params.}}{Named vector for additional parameters.}
}}

\seealso{
Other outcome: 
\code{\link{BinaryOutcome-class}},
\code{\link{ContinuousOutcome-class}},
\code{\link{Outcome-class}},
\code{\link{OutcomeContinuousNormal-class}},
\code{\link{OutcomeSurvExponential-class}},
\code{\link{OutcomeSurvPEM-class}},
\code{\link{OutcomeSurvWeibullPH-class}},
\code{\link{TimeToEvent-class}}
}
\concept{outcome}
