% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_covariates.R
\name{sim_covariates}
\alias{sim_covariates}
\title{Specify covariates for simulation study}
\usage{
sim_covariates(
  covariates,
  covariance_internal,
  covariance_external = covariance_internal
)
}
\arguments{
\item{covariates}{list. Named list of covariate mean values or probabilities as
generated through \code{bin_var()} (class \code{SimVarBin} or \code{cont_var()}
(class \code{SimVarCont}). See \code{details} for more information.}

\item{covariance_internal}{matrix. Covariance matrix before binarization
for internal patients.}

\item{covariance_external}{matrix. Covariance matrix before binarization
for external patients. Defaults to the internal covariance.}
}
\value{
Object of class \code{SimCovariates}
}
\description{
Provide details on the desired covariate distributions and covariance for
for a simulation study.
}
\details{
This function is intended to specify the number of covariates and
relationships between them for the purposes of designing a simulation
study in \code{psborrow2}. Because the outcome model does not necessarily
need to adjust for covariates, this function is not necessary in
\code{create_simulation_obj()}. The relationship between the treatment
and the outcome is specified elsewhere (i.e, in \code{sim_survival()} or
\code{sim_binary_event()}).

We need a few things to
}
\examples{

set.seed(123)
covmat <- matrix(rWishart(1, 2, diag(2)), ncol = 2)

covset1 <- sim_covariates(
  covariates = list(
    cov1 = bin_var(0.5, 0.5),
    cov2 = cont_var(100, 130)
  ),
  covariance_internal = covmat
)
}
\seealso{
Other simulation: 
\code{\link{sim_samplesize}()}
}
\concept{simulation}
