% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_artifacts.R
\name{estimate_artifacts}
\alias{estimate_artifacts}
\alias{estimate_rxxa}
\alias{estimate_rxxi}
\alias{estimate_ut}
\alias{estimate_ux}
\alias{estimate_ryya}
\alias{estimate_ryyi}
\alias{estimate_uy}
\alias{estimate_up}
\alias{estimate_rxxa_u}
\alias{estimate_rxxi_u}
\title{Estimation of applicant and incumbent reliabilities and of true- and observed-score u ratios}
\usage{
estimate_rxxa(
  rxxi,
  ux,
  ux_observed = TRUE,
  indirect_rr = TRUE,
  rxxi_type = "alpha"
)

estimate_rxxi(
  rxxa,
  ux,
  ux_observed = TRUE,
  indirect_rr = TRUE,
  rxxa_type = "alpha"
)

estimate_ut(ux, rxx, rxx_restricted = TRUE)

estimate_ux(ut, rxx, rxx_restricted = TRUE)

estimate_ryya(
  ryyi,
  rxyi,
  ux,
  rxx = 1,
  rxx_restricted = FALSE,
  ux_observed = TRUE,
  indirect_rr = TRUE,
  rxx_type = "alpha"
)

estimate_ryyi(
  ryya,
  rxyi,
  ux,
  rxx = 1,
  rxx_restricted = FALSE,
  ux_observed = TRUE,
  indirect_rr = TRUE,
  rxx_type = "alpha"
)

estimate_uy(ryyi, ryya, indirect_rr = TRUE, ryy_type = "alpha")

estimate_up(ryyi, ryya)

estimate_rxxa_u(ux, ut)

estimate_rxxi_u(ux, ut)
}
\arguments{
\item{rxxi}{Vector of incumbent reliability estimates for X.}

\item{ux}{Vector of observed-score u ratios for X (if used in the context of estimating a reliability value, a true-score u ratio may be supplied by setting ux_observed to \code{FALSE}).}

\item{ux_observed}{Logical vector determining whether each element of ux is an observed-score u ratio (\code{TRUE}) or a true-score u ratio (\code{FALSE}).}

\item{indirect_rr}{Logical vector determining whether each reliability value is associated with indirect range restriction (\code{TRUE}) or direct range restriction (\code{FALSE}). Note #1: For \code{estimate_ryya} and \code{estimate_ryyi}, this argument refers to whether X is indirectly or directly range restricted (Y is assumed to always be indirectly range restricted via selection on X or another variable). Note #2: When rxxi_type, rxxa_type, or rxx_type refers to an internal consistency reliability method, the corresponding reliability estimates will be treated as being impacted by indirect range restriction because, even when X is directly range restricted, the inter-item relations used to evaluate internal consistency reliability are indirectly range restricted via selection on X's total scores.}

\item{rxxi_type, rxxa_type, rxx_type, ryy_type}{String vector identifying the types of reliability estimates supplied (e.g., "alpha", "retest", "interrater_r", "splithalf"). See the documentation for \code{\link{ma_r}} for a full list of acceptable reliability types.}

\item{rxxa}{Vector of applicant reliability estimates for X.}

\item{rxx}{Vector of reliability estimates for X (used in the context of estimating ux and ut - specify that reliability is an incumbent value by setting rxx_restricted to \code{FALSE}).}

\item{rxx_restricted}{Logical vector determining whether each element of rxx is an incumbent reliability (\code{TRUE}) or an applicant reliability (\code{FALSE}).}

\item{ut}{Vector of true-score u ratios for X.}

\item{ryyi}{Vector of incumbent reliability estimates for Y.}

\item{rxyi}{Vector of observed-score incumbent correlations between X and Y.}

\item{ryya}{Vector of applicant reliability estimates for Y.}
}
\value{
A vector of estimated artifact values.
}
\description{
Functions to estimate the values of artifacts from other artifacts. These functions allow for reliability estimates to be corrected/attenuated for range restriction and allow
u ratios to be converted between observed-score and true-score metrics. Some functions also allow for the extrapolation of an artifact from other available information.

Available functions include:
\itemize{
\item{\code{estimate_rxxa}: Estimate the applicant reliability of variable X from X's incumbent reliability value and X's observed-score or true-score u ratio.}
\item{\code{estimate_rxxa_u}: Estimate the applicant reliability of variable X from X's observed-score and true-score u ratios.}
\item{\code{estimate_rxxi}: Estimate the incumbent reliability of variable X from X's applicant reliability value and X's observed-score or true-score u ratio.}
\item{\code{estimate_rxxi_u}: Estimate the incumbent reliability of variable X from X's observed-score and true-score u ratios.}
\item{\code{estimate_ux}: Estimate the true-score u ratio for variable X from X's reliability coefficient and X's observed-score u ratio.}
\item{\code{estimate_uy}: Estimate the observed-score u ratio for variable X from X's reliability coefficient and X's true-score u ratio.}
\item{\code{estimate_ryya}: Estimate the applicant reliability of variable Y from Y's incumbent reliability value, Y's correlation with X, and X's u ratio.}
\item{\code{estimate_ryyi}: Estimate the incumbent reliability of variable Y from Y's applicant reliability value, Y's correlation with X, and X's u ratio.}
\item{\code{estimate_uy}: Estimate the observed-score u ratio for variable Y from Y's applicant and incumbent reliability coefficients.}
\item{\code{estimate_up}: Estimate the true-score u ratio for variable Y from Y's applicant and incumbent reliability coefficients.}
}
}
\details{
#### Formulas to estimate rxxa ####

Formulas for indirect range restriction:
\deqn{\rho_{XX_{a}}=1-u_{X}^{2}\left(1-\rho_{XX_{i}}\right)}{rxxa = 1 - ux^2 * (1 - rxxi)}
\deqn{\rho_{XX_{a}}=\frac{\rho_{XX_{i}}}{\rho_{XX_{i}}+u_{T}^{2}-\rho_{XX_{i}}u_{T}^{2}}}{rxxa = rxxi / (rxxi + ut^2 - rxxi * ut^2)}

Formula for direct range restriction:
\deqn{\rho_{XX_{a}}=\frac{\rho_{XX_{i}}}{u_{X}^{2}\left[1+\rho_{XX_{i}}\left(\frac{1}{u_{X}^{2}}-1\right)\right]}}{rxxa = rxxi / (ux^2 * (1 + rxxi * (ux^-2 - 1)))}



#### Formulas to estimate rxxi ####

Formulas for indirect range restriction:
\deqn{\rho_{XX_{i}}=1-\frac{1-\rho_{XX_{a}}}{u_{X}^{2}}}{1 - (1 - rxxa) / ux^2}
\deqn{\rho_{XX_{i}}=1-\frac{1-\rho_{XX_{a}}}{\rho_{XX_{a}}\left[u_{T}^{2}-\left(1-\frac{1}{\rho_{XX_{a}}}\right)\right]}}{rxxi = 1 - (1 - rxxa) / (rxxa * (ut^2 - (1 - 1 / rxxa)))}

Formula for direct range restriction:
\deqn{\rho_{XX_{i}}=\frac{\rho_{XX_{i}}u_{X}^{2}}{1+\rho_{XX_{i}}\left(u_{X}^{2}-1\right)}}{rxxi = (rxxa * ux^2) / (1 + rxxa * (ux^2 - 1))}



#### Formulas to estimate ut ####

\deqn{u_{T}=\sqrt{\frac{\rho_{XX_{i}}u_{X}^{2}}{1+\rho_{XX_{i}}u_{X}^{2}-u_{X}^{2}}}}{ut = sqrt((rxxi * ux^2) / (1 + rxxi * ux^2 - ux^2))}
\deqn{u_{T}=\sqrt{\frac{u_{X}^{2}-\left(1-\rho_{XX_{a}}\right)}{\rho_{XX_{a}}}}}{ut = sqrt((ux^2 - (1 - rxxa)) / rxxa)}



#### Formulas to estimate ux ####
\deqn{u_{X}=\sqrt{\frac{u_{T}^{2}}{\rho_{XX_{i}}\left(1+\frac{u_{T}^{2}}{\rho_{XX_{i}}}-u_{T}^{2}\right)}}}{ux = sqrt(ut^2 / (rxxi * (1 + ut^2 / rxxi - ut^2)))}
\deqn{u_{X}=\sqrt{\rho_{XX_{a}}\left[u_{T}^{2}-\left(1-\frac{1}{\rho_{XX_{a}}}\right)\right]}}{ux = sqrt((ut^2 - (1 - 1 / rxxa)) * rxxa)}



#### Formulas to estimate ryya ####
Formula for direct range restriction (i.e., when selection is based on X):
\deqn{\rho_{YY_{a}}=1-\frac{1-\rho_{YY_{i}}}{1-\rho_{XY_{i}}^{2}\left(1-\frac{1}{u_{X}^{2}}\right)}}{ryya = 1 - (1 - ryyi) / (1 - rxyi^2 * (1 - ux^-2))}

Formula for indirect range restriction (i.e., when selection is based on a variable other than X):
\deqn{\rho_{YY_{a}}=1-\frac{1-\rho_{YY_{i}}}{1-\rho_{TY_{i}}^{2}\left(1-\frac{1}{u_{T}^{2}}\right)}}{ryya = 1 - (1 - ryyi) / (1 - rtyi^2 * (1 - ut^-2))}



#### Formulas to estimate ryyi ####
Formula for direct range restriction (i.e., when selection is based on X):
\deqn{\rho_{YY_{i}}=1-\left(1-\rho_{YY_{a}}\right)\left[1-\rho_{XY_{i}}^{2}\left(1-\frac{1}{u_{X}^{2}}\right)\right]}{ryyi = 1 - (1 - ryya) * (1 - rxyi^2 * (1 - ux^-2))}

Formula for indirect range restriction (i.e., when selection is based on a variable other than X):
\deqn{\rho_{YY_{i}}=1-\left(1-\rho_{YY_{a}}\right)\left[1-\rho_{TY_{i}}^{2}\left(1-\frac{1}{u_{X}^{2}}\right)\right]}{ryyi = 1 - (1 - ryya) * (1 - rtyi^2 * (1 - ut^-2))}



#### Formula to estimate uy ####
\deqn{u_{Y}=\sqrt{\frac{1-\rho_{YY_{a}}}{1-\rho_{YY_{i}}}}}{uy = sqrt((1 - ryya) / (1 - ryyi)}



#### Formula to estimate up ####
\deqn{u_{P}=\sqrt{\frac{\frac{1-\rho_{YY_{a}}}{1-\rho_{YY_{i}}}-\left(1-\rho_{YY_{a}}\right)}{\rho_{YY_{a}}}}}{up = sqrt(((1 - ryya) / (1 - ryyi) - (1 - ryya)) / ryya)}
}
\examples{
estimate_rxxa(rxxi = .8, ux = .8, ux_observed = TRUE)
estimate_rxxi(rxxa = .8, ux = .8, ux_observed = TRUE)
estimate_ut(ux = .8, rxx = .8, rxx_restricted = TRUE)
estimate_ux(ut = .8, rxx = .8, rxx_restricted = TRUE)
estimate_ryya(ryyi = .8, rxyi = .3, ux = .8)
estimate_ryyi(ryya = .8, rxyi = .3, ux = .8)
estimate_uy(ryyi = c(.5, .7), ryya = c(.7, .8))
estimate_up(ryyi = c(.5, .7), ryya = c(.7, .8))
estimate_rxxa_u(ux = c(.7, .8), ut = c(.65, .75))
estimate_rxxi_u(ux = c(.7, .8), ut = c(.65, .75))
}
\references{
Schmidt, F. L., & Hunter, J. E. (2015).
\emph{Methods of meta-analysis: Correcting error and bias in research findings} (3rd ed.).
Sage. \doi{10.4135/9781483398105} p. 127.

Le, H., & Schmidt, F. L. (2006).
Correcting for indirect range restriction in meta-analysis: Testing a new meta-analytic procedure.
\emph{Psychological Methods, 11}(4), 416–438. \doi{10.1037/1082-989X.11.4.416}

Hunter, J. E., Schmidt, F. L., & Le, H. (2006).
Implications of direct and indirect range restriction for meta-analysis methods and findings.
\emph{Journal of Applied Psychology, 91}(3), 594–612. \doi{10.1037/0021-9010.91.3.594}

Le, H., Oh, I.-S., Schmidt, F. L., & Wooldridge, C. D. (2016).
Correction for range restriction in meta-analysis revisited: Improvements and implications for organizational research.
\emph{Personnel Psychology, 69}(4), 975–1008. \doi{10.1111/peps.12122}
}
