% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metosite.R
\name{meto.scan}
\alias{meto.scan}
\title{Scans a Protein in Search of  MetO Sites}
\usage{
meto.scan(up_id, report = 1)
}
\arguments{
\item{up_id}{a character string corresponding to the UniProt ID.}

\item{report}{it should be a natural number between 1 and 3.}
}
\value{
This function returns a report regarding the MetO sites found, if any, in the protein of interest.
}
\description{
Scans a given protein in search of MetO sites.
}
\details{
When the 'report' parameter has been set to 1, this function returns a brief report providing the position,  the function category and literature references concerning the residues detected as MetO, if any. If we wish to obtain a more detailed report, the option should be: report = 2. Finally, If we want a detailed and printable report (saved in the current directory), we should set report = 3
}
\examples{
meto.scan('P01009')
}
\references{
Valverde et al. 2019. Bioinformatics 35:4849-4850 (PMID: 31197322)
}
\seealso{
meto.search(), meto.list()
}
\author{
Juan Carlos Aledo
}
