% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MarkUse.R
\name{MarkUse}
\alias{MarkUse}
\title{Mark Use Day by Subject}
\usage{
MarkUse(
  targetDrugs_char,
  drugs_df = NULL,
  reportSource = c("TFB", "UDSAB", "UDS"),
  retainEmptyRows = FALSE
)
}
\arguments{
\item{targetDrugs_char}{A character vector including which drugs should be
counted against the subject}

\item{drugs_df}{A data frame with columns \code{who}, \code{when}, and
\code{what}. This data frame measures which drugs were used by each
subject over all days of treatment. This data set must also include a
column \code{source}, which marks from which reporting source the drug use
was recorded}

\item{reportSource}{A character vector matching the source of the reported
drug use. The options must be from Timeline Followback (\code{"TFB"})
questionnaires or daily urine drug screens (\code{"UDS"} or\code{"UDSAB"}).}

\item{retainEmptyRows}{A logical flag to force rows for participants who did
not have UDS positive for the substances listed in \code{targetDrugs_char}
to be retained in the final results (with \code{NA} for \code{"when"} and
\code{"source"}). Defaults to \code{FALSE} because the entire point of
this function is to mark substance \emph{USE}, not a lack thereof;
however, this flag is needed for the vignette (because we forced the
inclusion of a participant with no recorded UDS for pedagogical purposes).}
}
\value{
A modification of the \code{drugs_df} data set: the columns are
\code{"who"}, \code{"when"}, and \code{"source"}; each row corresponds
to one use day per subject per use source (if, for instance, there is drug
use for a particular day recorded in both TFB and UDS, then that day will
have two rows in the resulting data set).
}
\description{
Mark Use Day by Subject
}
\details{
This function is basically just a fancy wrapper around some dplyr
code. We just don't want the user to have to 1) know dplyr, or 2) write
the code themselves.
}
\examples{
   MarkUse(c("Crack", "Pcp", "Opioid"))
}
