// Generated by rstantools.  Do not edit by hand.

/*
    publipha is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    publipha is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with publipha.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_psma_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_psma");
    reader.add_event(1, 1, "include", "/chunks/psma_likelihoods.stan");
    reader.add_event(1, 0, "start", "/chunks/psma_likelihoods.stan");
    reader.add_event(1, 0, "include", "/chunks/densities.stan");
    reader.add_event(1, 0, "start", "/chunks/densities.stan");
    reader.add_event(19, 18, "end", "/chunks/densities.stan");
    reader.add_event(19, 1, "restart", "/chunks/psma_likelihoods.stan");
    reader.add_event(95, 77, "end", "/chunks/psma_likelihoods.stan");
    reader.add_event(95, 2, "restart", "model_psma");
    reader.add_event(169, 74, "end", "model_psma");
    return reader;
}
template <bool propto, typename T0__, typename T1__, typename T2__, typename T3__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type
lower_normal_lpdf(const T0__& y,
                      const T1__& mean,
                      const T2__& sd,
                      const T3__& lower, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        current_statement_begin__ = 3;
        return stan::math::promote_scalar<fun_return_scalar_t__>((normal_log(y, mean, sd) - normal_ccdf_log(lower, mean, sd)));
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
template <typename T0__, typename T1__, typename T2__, typename T3__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type
lower_normal_lpdf(const T0__& y,
                      const T1__& mean,
                      const T2__& sd,
                      const T3__& lower, std::ostream* pstream__) {
    return lower_normal_lpdf<false>(y,mean,sd,lower, pstream__);
}
struct lower_normal_lpdf_functor__ {
    template <bool propto, typename T0__, typename T1__, typename T2__, typename T3__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type
    operator()(const T0__& y,
                      const T1__& mean,
                      const T2__& sd,
                      const T3__& lower, std::ostream* pstream__) const {
        return lower_normal_lpdf(y, mean, sd, lower, pstream__);
    }
};
template <bool propto, typename T0__, typename T1__, typename T2__, typename T3__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type
upper_normal_lpdf(const T0__& y,
                      const T1__& mean,
                      const T2__& sd,
                      const T3__& upper, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        current_statement_begin__ = 7;
        return stan::math::promote_scalar<fun_return_scalar_t__>((normal_log(y, mean, sd) - normal_cdf_log(upper, mean, sd)));
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
template <typename T0__, typename T1__, typename T2__, typename T3__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type
upper_normal_lpdf(const T0__& y,
                      const T1__& mean,
                      const T2__& sd,
                      const T3__& upper, std::ostream* pstream__) {
    return upper_normal_lpdf<false>(y,mean,sd,upper, pstream__);
}
struct upper_normal_lpdf_functor__ {
    template <bool propto, typename T0__, typename T1__, typename T2__, typename T3__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type
    operator()(const T0__& y,
                      const T1__& mean,
                      const T2__& sd,
                      const T3__& upper, std::ostream* pstream__) const {
        return upper_normal_lpdf(y, mean, sd, upper, pstream__);
    }
};
template <bool propto, typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type
inner_normal_lpdf(const T0__& y,
                      const T1__& mean,
                      const T2__& sd,
                      const T3__& lower,
                      const T4__& upper, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        current_statement_begin__ = 11;
        return stan::math::promote_scalar<fun_return_scalar_t__>((normal_log(y, mean, sd) - stan::math::log((normal_cdf(upper, mean, sd) - normal_cdf(lower, mean, sd)))));
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type
inner_normal_lpdf(const T0__& y,
                      const T1__& mean,
                      const T2__& sd,
                      const T3__& lower,
                      const T4__& upper, std::ostream* pstream__) {
    return inner_normal_lpdf<false>(y,mean,sd,lower,upper, pstream__);
}
struct inner_normal_lpdf_functor__ {
    template <bool propto, typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type
    operator()(const T0__& y,
                      const T1__& mean,
                      const T2__& sd,
                      const T3__& lower,
                      const T4__& upper, std::ostream* pstream__) const {
        return inner_normal_lpdf(y, mean, sd, lower, upper, pstream__);
    }
};
template <bool propto, typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type
double_normal_lpdf(const T0__& y,
                       const T1__& mean,
                       const T2__& sd,
                       const T3__& lower,
                       const T4__& upper, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        current_statement_begin__ = 17;
        return stan::math::promote_scalar<fun_return_scalar_t__>((normal_log(y, mean, sd) - stan::math::log((normal_cdf(upper, mean, sd) + normal_cdf(-(lower), -(mean), sd)))));
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type
double_normal_lpdf(const T0__& y,
                       const T1__& mean,
                       const T2__& sd,
                       const T3__& lower,
                       const T4__& upper, std::ostream* pstream__) {
    return double_normal_lpdf<false>(y,mean,sd,lower,upper, pstream__);
}
struct double_normal_lpdf_functor__ {
    template <bool propto, typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type
    operator()(const T0__& y,
                       const T1__& mean,
                       const T2__& sd,
                       const T3__& lower,
                       const T4__& upper, std::ostream* pstream__) const {
        return double_normal_lpdf(y, mean, sd, lower, upper, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type
normal_lnorm(const T0__& theta,
                 const T1__& tau,
                 const T2__& sigma,
                 const std::vector<T3__>& alpha,
                 const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& eta, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 26;
        int k(0);
        (void) k;  // dummy to suppress unused var warning
        stan::math::fill(k, std::numeric_limits<int>::min());
        stan::math::assign(k,size(alpha));
        current_statement_begin__ = 27;
        local_scalar_t__ cutoff(DUMMY_VAR__);
        (void) cutoff;  // dummy to suppress unused var warning
        stan::math::initialize(cutoff, DUMMY_VAR__);
        stan::math::fill(cutoff, DUMMY_VAR__);
        current_statement_begin__ = 28;
        local_scalar_t__ cdf(DUMMY_VAR__);
        (void) cdf;  // dummy to suppress unused var warning
        stan::math::initialize(cdf, DUMMY_VAR__);
        stan::math::fill(cdf, DUMMY_VAR__);
        current_statement_begin__ = 29;
        validate_non_negative_index("summands", "(k - 1)", (k - 1));
        std::vector<local_scalar_t__  > summands((k - 1), local_scalar_t__(DUMMY_VAR__));
        stan::math::initialize(summands, DUMMY_VAR__);
        stan::math::fill(summands, DUMMY_VAR__);
        current_statement_begin__ = 31;
        stan::model::assign(summands, 
                    stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                    get_base1(eta, 1, "eta", 1), 
                    "assigning variable summands");
        current_statement_begin__ = 33;
        for (int i = 2; i <= (k - 1); ++i) {
            current_statement_begin__ = 34;
            stan::math::assign(cutoff, (inv_Phi((1 - get_base1(alpha, i, "alpha", 1))) * sigma));
            current_statement_begin__ = 35;
            stan::math::assign(cdf, normal_cdf(cutoff, theta, stan::math::sqrt(((tau * tau) + (sigma * sigma)))));
            current_statement_begin__ = 36;
            stan::model::assign(summands, 
                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                        (cdf * (get_base1(eta, i, "eta", 1) - get_base1(eta, (i - 1), "eta", 1))), 
                        "assigning variable summands");
        }
        current_statement_begin__ = 40;
        return stan::math::promote_scalar<fun_return_scalar_t__>(stan::math::log(sum(summands)));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct normal_lnorm_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type
    operator()(const T0__& theta,
                 const T1__& tau,
                 const T2__& sigma,
                 const std::vector<T3__>& alpha,
                 const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& eta, std::ostream* pstream__) const {
        return normal_lnorm(theta, tau, sigma, alpha, eta, pstream__);
    }
};
template <bool propto, typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type
psma_normal_prior_mini_lpdf(const T0__& theta,
                                const T1__& theta0,
                                const T2__& tau,
                                const T3__& sigma,
                                const std::vector<T4__>& alpha,
                                const Eigen::Matrix<T5__, Eigen::Dynamic, 1>& eta, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 49;
        local_scalar_t__ y(DUMMY_VAR__);
        (void) y;  // dummy to suppress unused var warning
        stan::math::initialize(y, DUMMY_VAR__);
        stan::math::fill(y, DUMMY_VAR__);
        stan::math::assign(y,normal_log(theta, theta0, tau));
        current_statement_begin__ = 50;
        local_scalar_t__ normalizer(DUMMY_VAR__);
        (void) normalizer;  // dummy to suppress unused var warning
        stan::math::initialize(normalizer, DUMMY_VAR__);
        stan::math::fill(normalizer, DUMMY_VAR__);
        stan::math::assign(normalizer,normal_lnorm(theta0, tau, sigma, alpha, eta, pstream__));
        current_statement_begin__ = 51;
        return stan::math::promote_scalar<fun_return_scalar_t__>((y - normalizer));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type
psma_normal_prior_mini_lpdf(const T0__& theta,
                                const T1__& theta0,
                                const T2__& tau,
                                const T3__& sigma,
                                const std::vector<T4__>& alpha,
                                const Eigen::Matrix<T5__, Eigen::Dynamic, 1>& eta, std::ostream* pstream__) {
    return psma_normal_prior_mini_lpdf<false>(theta,theta0,tau,sigma,alpha,eta, pstream__);
}
struct psma_normal_prior_mini_lpdf_functor__ {
    template <bool propto, typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type
    operator()(const T0__& theta,
                                const T1__& theta0,
                                const T2__& tau,
                                const T3__& sigma,
                                const std::vector<T4__>& alpha,
                                const Eigen::Matrix<T5__, Eigen::Dynamic, 1>& eta, std::ostream* pstream__) const {
        return psma_normal_prior_mini_lpdf(theta, theta0, tau, sigma, alpha, eta, pstream__);
    }
};
template <bool propto, typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type
psma_normal_mini_lpdf(const T0__& x,
                          const T1__& theta,
                          const T2__& sigma,
                          const std::vector<T3__>& alpha,
                          const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& eta, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 56;
        int k(0);
        (void) k;  // dummy to suppress unused var warning
        stan::math::fill(k, std::numeric_limits<int>::min());
        stan::math::assign(k,size(alpha));
        current_statement_begin__ = 57;
        local_scalar_t__ y(DUMMY_VAR__);
        (void) y;  // dummy to suppress unused var warning
        stan::math::initialize(y, DUMMY_VAR__);
        stan::math::fill(y, DUMMY_VAR__);
        stan::math::assign(y,normal_log(x, theta, sigma));
        current_statement_begin__ = 58;
        local_scalar_t__ u(DUMMY_VAR__);
        (void) u;  // dummy to suppress unused var warning
        stan::math::initialize(u, DUMMY_VAR__);
        stan::math::fill(u, DUMMY_VAR__);
        stan::math::assign(u,(1 - normal_cdf(x, 0, sigma)));
        current_statement_begin__ = 60;
        for (int i = 1; i <= (k - 1); ++i) {
            current_statement_begin__ = 61;
            if (as_bool((primitive_value(logical_lt(get_base1(alpha, i, "alpha", 1), u)) && primitive_value(logical_lte(u, get_base1(alpha, (i + 1), "alpha", 1)))))) {
                current_statement_begin__ = 62;
                stan::math::assign(y, (y + stan::math::log(get_base1(eta, i, "eta", 1))));
                current_statement_begin__ = 63;
                break;
            }
        }
        current_statement_begin__ = 67;
        return stan::math::promote_scalar<fun_return_scalar_t__>(y);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type
psma_normal_mini_lpdf(const T0__& x,
                          const T1__& theta,
                          const T2__& sigma,
                          const std::vector<T3__>& alpha,
                          const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& eta, std::ostream* pstream__) {
    return psma_normal_mini_lpdf<false>(x,theta,sigma,alpha,eta, pstream__);
}
struct psma_normal_mini_lpdf_functor__ {
    template <bool propto, typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type
    operator()(const T0__& x,
                          const T1__& theta,
                          const T2__& sigma,
                          const std::vector<T3__>& alpha,
                          const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& eta, std::ostream* pstream__) const {
        return psma_normal_mini_lpdf(x, theta, sigma, alpha, eta, pstream__);
    }
};
template <bool propto, typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type
psma_normal_maxi_lpdf(const T0__& x,
                          const T1__& theta,
                          const T2__& sigma,
                          const std::vector<T3__>& alpha,
                          const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& eta, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 72;
        local_scalar_t__ y(DUMMY_VAR__);
        (void) y;  // dummy to suppress unused var warning
        stan::math::initialize(y, DUMMY_VAR__);
        stan::math::fill(y, DUMMY_VAR__);
        stan::math::assign(y,psma_normal_mini_lpdf(x, theta, sigma, alpha, eta, pstream__));
        current_statement_begin__ = 73;
        local_scalar_t__ normalizer(DUMMY_VAR__);
        (void) normalizer;  // dummy to suppress unused var warning
        stan::math::initialize(normalizer, DUMMY_VAR__);
        stan::math::fill(normalizer, DUMMY_VAR__);
        stan::math::assign(normalizer,normal_lnorm(theta, 0, sigma, alpha, eta, pstream__));
        current_statement_begin__ = 74;
        return stan::math::promote_scalar<fun_return_scalar_t__>((y - normalizer));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type
psma_normal_maxi_lpdf(const T0__& x,
                          const T1__& theta,
                          const T2__& sigma,
                          const std::vector<T3__>& alpha,
                          const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& eta, std::ostream* pstream__) {
    return psma_normal_maxi_lpdf<false>(x,theta,sigma,alpha,eta, pstream__);
}
struct psma_normal_maxi_lpdf_functor__ {
    template <bool propto, typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type
    operator()(const T0__& x,
                          const T1__& theta,
                          const T2__& sigma,
                          const std::vector<T3__>& alpha,
                          const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& eta, std::ostream* pstream__) const {
        return psma_normal_maxi_lpdf(x, theta, sigma, alpha, eta, pstream__);
    }
};
template <bool propto, typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type
psma_normal_marginal_lpdf(const T0__& x,
                              const T1__& theta0,
                              const T2__& tau,
                              const T3__& sigma,
                              const std::vector<T4__>& alpha,
                              const Eigen::Matrix<T5__, Eigen::Dynamic, 1>& eta, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 82;
        int k(0);
        (void) k;  // dummy to suppress unused var warning
        stan::math::fill(k, std::numeric_limits<int>::min());
        stan::math::assign(k,size(alpha));
        current_statement_begin__ = 83;
        local_scalar_t__ y(DUMMY_VAR__);
        (void) y;  // dummy to suppress unused var warning
        stan::math::initialize(y, DUMMY_VAR__);
        stan::math::fill(y, DUMMY_VAR__);
        stan::math::assign(y,normal_log(x, theta0, stan::math::sqrt(((tau * tau) + (sigma * sigma)))));
        current_statement_begin__ = 84;
        local_scalar_t__ u(DUMMY_VAR__);
        (void) u;  // dummy to suppress unused var warning
        stan::math::initialize(u, DUMMY_VAR__);
        stan::math::fill(u, DUMMY_VAR__);
        stan::math::assign(u,(1 - normal_cdf(x, 0, sigma)));
        current_statement_begin__ = 85;
        local_scalar_t__ normalizer(DUMMY_VAR__);
        (void) normalizer;  // dummy to suppress unused var warning
        stan::math::initialize(normalizer, DUMMY_VAR__);
        stan::math::fill(normalizer, DUMMY_VAR__);
        stan::math::assign(normalizer,normal_lnorm(theta0, tau, sigma, alpha, eta, pstream__));
        current_statement_begin__ = 87;
        for (int i = 1; i <= (k - 1); ++i) {
            current_statement_begin__ = 88;
            if (as_bool((primitive_value(logical_lt(get_base1(alpha, i, "alpha", 1), u)) && primitive_value(logical_lte(u, get_base1(alpha, (i + 1), "alpha", 1)))))) {
                current_statement_begin__ = 89;
                stan::math::assign(y, (y + stan::math::log(get_base1(eta, i, "eta", 1))));
                current_statement_begin__ = 90;
                break;
            }
        }
        current_statement_begin__ = 94;
        return stan::math::promote_scalar<fun_return_scalar_t__>((y - normalizer));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type
psma_normal_marginal_lpdf(const T0__& x,
                              const T1__& theta0,
                              const T2__& tau,
                              const T3__& sigma,
                              const std::vector<T4__>& alpha,
                              const Eigen::Matrix<T5__, Eigen::Dynamic, 1>& eta, std::ostream* pstream__) {
    return psma_normal_marginal_lpdf<false>(x,theta0,tau,sigma,alpha,eta, pstream__);
}
struct psma_normal_marginal_lpdf_functor__ {
    template <bool propto, typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type
    operator()(const T0__& x,
                              const T1__& theta0,
                              const T2__& tau,
                              const T3__& sigma,
                              const std::vector<T4__>& alpha,
                              const Eigen::Matrix<T5__, Eigen::Dynamic, 1>& eta, std::ostream* pstream__) const {
        return psma_normal_marginal_lpdf(x, theta0, tau, sigma, alpha, eta, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_psma
  : public stan::model::model_base_crtp<model_psma> {
private:
        int N;
        int k;
        std::vector<double> alpha;
        std::vector<double> yi;
        std::vector<double> vi;
        vector_d eta0;
        double theta0_mean;
        double theta0_sd;
        double tau_mean;
        double tau_sd;
        double u_min;
        double u_max;
        double shape;
        double scale;
        int tau_prior;
public:
    model_psma(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_psma(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_psma_namespace::model_psma";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 101;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            check_greater_or_equal(function__, "N", N, 0);
            current_statement_begin__ = 102;
            context__.validate_dims("data initialization", "k", "int", context__.to_vec());
            k = int(0);
            vals_i__ = context__.vals_i("k");
            pos__ = 0;
            k = vals_i__[pos__++];
            check_greater_or_equal(function__, "k", k, 0);
            current_statement_begin__ = 103;
            validate_non_negative_index("alpha", "k", k);
            context__.validate_dims("data initialization", "alpha", "double", context__.to_vec(k));
            alpha = std::vector<double>(k, double(0));
            vals_r__ = context__.vals_r("alpha");
            pos__ = 0;
            size_t alpha_k_0_max__ = k;
            for (size_t k_0__ = 0; k_0__ < alpha_k_0_max__; ++k_0__) {
                alpha[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 104;
            validate_non_negative_index("yi", "N", N);
            context__.validate_dims("data initialization", "yi", "double", context__.to_vec(N));
            yi = std::vector<double>(N, double(0));
            vals_r__ = context__.vals_r("yi");
            pos__ = 0;
            size_t yi_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < yi_k_0_max__; ++k_0__) {
                yi[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 105;
            validate_non_negative_index("vi", "N", N);
            context__.validate_dims("data initialization", "vi", "double", context__.to_vec(N));
            vi = std::vector<double>(N, double(0));
            vals_r__ = context__.vals_r("vi");
            pos__ = 0;
            size_t vi_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < vi_k_0_max__; ++k_0__) {
                vi[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 108;
            validate_non_negative_index("eta0", "(k - 1)", (k - 1));
            context__.validate_dims("data initialization", "eta0", "vector_d", context__.to_vec((k - 1)));
            eta0 = Eigen::Matrix<double, Eigen::Dynamic, 1>((k - 1));
            vals_r__ = context__.vals_r("eta0");
            pos__ = 0;
            size_t eta0_j_1_max__ = (k - 1);
            for (size_t j_1__ = 0; j_1__ < eta0_j_1_max__; ++j_1__) {
                eta0(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 109;
            context__.validate_dims("data initialization", "theta0_mean", "double", context__.to_vec());
            theta0_mean = double(0);
            vals_r__ = context__.vals_r("theta0_mean");
            pos__ = 0;
            theta0_mean = vals_r__[pos__++];
            current_statement_begin__ = 110;
            context__.validate_dims("data initialization", "theta0_sd", "double", context__.to_vec());
            theta0_sd = double(0);
            vals_r__ = context__.vals_r("theta0_sd");
            pos__ = 0;
            theta0_sd = vals_r__[pos__++];
            check_greater_or_equal(function__, "theta0_sd", theta0_sd, 0);
            current_statement_begin__ = 111;
            context__.validate_dims("data initialization", "tau_mean", "double", context__.to_vec());
            tau_mean = double(0);
            vals_r__ = context__.vals_r("tau_mean");
            pos__ = 0;
            tau_mean = vals_r__[pos__++];
            current_statement_begin__ = 112;
            context__.validate_dims("data initialization", "tau_sd", "double", context__.to_vec());
            tau_sd = double(0);
            vals_r__ = context__.vals_r("tau_sd");
            pos__ = 0;
            tau_sd = vals_r__[pos__++];
            check_greater_or_equal(function__, "tau_sd", tau_sd, 0);
            current_statement_begin__ = 113;
            context__.validate_dims("data initialization", "u_min", "double", context__.to_vec());
            u_min = double(0);
            vals_r__ = context__.vals_r("u_min");
            pos__ = 0;
            u_min = vals_r__[pos__++];
            check_greater_or_equal(function__, "u_min", u_min, 0);
            current_statement_begin__ = 114;
            context__.validate_dims("data initialization", "u_max", "double", context__.to_vec());
            u_max = double(0);
            vals_r__ = context__.vals_r("u_max");
            pos__ = 0;
            u_max = vals_r__[pos__++];
            check_greater_or_equal(function__, "u_max", u_max, 0);
            current_statement_begin__ = 115;
            context__.validate_dims("data initialization", "shape", "double", context__.to_vec());
            shape = double(0);
            vals_r__ = context__.vals_r("shape");
            pos__ = 0;
            shape = vals_r__[pos__++];
            check_greater_or_equal(function__, "shape", shape, 0);
            current_statement_begin__ = 116;
            context__.validate_dims("data initialization", "scale", "double", context__.to_vec());
            scale = double(0);
            vals_r__ = context__.vals_r("scale");
            pos__ = 0;
            scale = vals_r__[pos__++];
            check_greater_or_equal(function__, "scale", scale, 0);
            current_statement_begin__ = 117;
            context__.validate_dims("data initialization", "tau_prior", "int", context__.to_vec());
            tau_prior = int(0);
            vals_i__ = context__.vals_i("tau_prior");
            pos__ = 0;
            tau_prior = vals_i__[pos__++];
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 123;
            num_params_r__ += 1;
            current_statement_begin__ = 124;
            num_params_r__ += 1;
            current_statement_begin__ = 125;
            validate_non_negative_index("weights", "(k - 1)", (k - 1));
            num_params_r__ += (k - 1);
            current_statement_begin__ = 126;
            validate_non_negative_index("theta", "N", N);
            num_params_r__ += (1 * N);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_psma() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 123;
        if (!(context__.contains_r("theta0")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable theta0 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("theta0");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "theta0", "double", context__.to_vec());
        double theta0(0);
        theta0 = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(theta0);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable theta0: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 124;
        if (!(context__.contains_r("tau")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable tau missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("tau");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "tau", "double", context__.to_vec());
        double tau(0);
        tau = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, tau);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable tau: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 125;
        if (!(context__.contains_r("weights")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable weights missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("weights");
        pos__ = 0U;
        validate_non_negative_index("weights", "(k - 1)", (k - 1));
        context__.validate_dims("parameter initialization", "weights", "vector_d", context__.to_vec((k - 1)));
        Eigen::Matrix<double, Eigen::Dynamic, 1> weights((k - 1));
        size_t weights_j_1_max__ = (k - 1);
        for (size_t j_1__ = 0; j_1__ < weights_j_1_max__; ++j_1__) {
            weights(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.positive_ordered_unconstrain(weights);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable weights: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 126;
        if (!(context__.contains_r("theta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable theta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("theta");
        pos__ = 0U;
        validate_non_negative_index("theta", "N", N);
        context__.validate_dims("parameter initialization", "theta", "double", context__.to_vec(N));
        std::vector<double> theta(N, double(0));
        size_t theta_k_0_max__ = N;
        for (size_t k_0__ = 0; k_0__ < theta_k_0_max__; ++k_0__) {
            theta[k_0__] = vals_r__[pos__++];
        }
        size_t theta_i_0_max__ = N;
        for (size_t i_0__ = 0; i_0__ < theta_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_unconstrain(theta[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable theta: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 123;
            local_scalar_t__ theta0;
            (void) theta0;  // dummy to suppress unused var warning
            if (jacobian__)
                theta0 = in__.scalar_constrain(lp__);
            else
                theta0 = in__.scalar_constrain();
            current_statement_begin__ = 124;
            local_scalar_t__ tau;
            (void) tau;  // dummy to suppress unused var warning
            if (jacobian__)
                tau = in__.scalar_lb_constrain(0, lp__);
            else
                tau = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 125;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> weights;
            (void) weights;  // dummy to suppress unused var warning
            if (jacobian__)
                weights = in__.positive_ordered_constrain((k - 1), lp__);
            else
                weights = in__.positive_ordered_constrain((k - 1));
            current_statement_begin__ = 126;
            std::vector<local_scalar_t__> theta;
            size_t theta_d_0_max__ = N;
            theta.reserve(theta_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < theta_d_0_max__; ++d_0__) {
                if (jacobian__)
                    theta.push_back(in__.scalar_constrain(lp__));
                else
                    theta.push_back(in__.scalar_constrain());
            }
            // transformed parameters
            current_statement_begin__ = 131;
            validate_non_negative_index("eta", "(k - 1)", (k - 1));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eta((k - 1));
            stan::math::initialize(eta, DUMMY_VAR__);
            stan::math::fill(eta, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 132;
            for (int i = 1; i <= (k - 1); ++i) {
                current_statement_begin__ = 132;
                stan::model::assign(eta, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(weights, (k - i), "weights", 1) / get_base1(weights, (k - 1), "weights", 1)), 
                            "assigning variable eta");
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 131;
            size_t eta_j_1_max__ = (k - 1);
            for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(eta(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: eta" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable eta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            // model body
            current_statement_begin__ = 137;
            lp_accum__.add(normal_log<propto__>(theta0, theta0_mean, theta0_sd));
            current_statement_begin__ = 139;
            if (as_bool(logical_eq(tau_prior, 1))) {
                current_statement_begin__ = 140;
                lp_accum__.add(normal_log<propto__>(tau, tau_mean, tau_sd));
                if (tau < 0) lp_accum__.add(-std::numeric_limits<double>::infinity());
                else lp_accum__.add(-normal_ccdf_log(0, tau_mean, tau_sd));
            } else if (as_bool(logical_eq(tau_prior, 2))) {
                current_statement_begin__ = 142;
                lp_accum__.add(uniform_log<propto__>(tau, u_min, u_max));
            } else if (as_bool(logical_eq(tau_prior, 3))) {
                current_statement_begin__ = 144;
                lp_accum__.add(inv_gamma_log<propto__>(tau, shape, scale));
            }
            current_statement_begin__ = 147;
            lp_accum__.add(gamma_log<propto__>(weights, eta0, 1));
            current_statement_begin__ = 149;
            for (int n = 1; n <= N; ++n) {
                current_statement_begin__ = 150;
                lp_accum__.add(psma_normal_prior_mini_lpdf<propto__>(get_base1(theta, n, "theta", 1), theta0, tau, stan::math::sqrt(get_base1(vi, n, "vi", 1)), alpha, eta, pstream__));
                current_statement_begin__ = 151;
                lp_accum__.add(psma_normal_mini_lpdf<propto__>(get_base1(yi, n, "yi", 1), get_base1(theta, n, "theta", 1), stan::math::sqrt(get_base1(vi, n, "vi", 1)), alpha, eta, pstream__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("theta0");
        names__.push_back("tau");
        names__.push_back("weights");
        names__.push_back("theta");
        names__.push_back("eta");
        names__.push_back("log_lik_marginal");
        names__.push_back("log_lik");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((k - 1));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((k - 1));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_psma_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double theta0 = in__.scalar_constrain();
        vars__.push_back(theta0);
        double tau = in__.scalar_lb_constrain(0);
        vars__.push_back(tau);
        Eigen::Matrix<double, Eigen::Dynamic, 1> weights = in__.positive_ordered_constrain((k - 1));
        size_t weights_j_1_max__ = (k - 1);
        for (size_t j_1__ = 0; j_1__ < weights_j_1_max__; ++j_1__) {
            vars__.push_back(weights(j_1__));
        }
        std::vector<double> theta;
        size_t theta_d_0_max__ = N;
        theta.reserve(theta_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < theta_d_0_max__; ++d_0__) {
            theta.push_back(in__.scalar_constrain());
        }
        size_t theta_k_0_max__ = N;
        for (size_t k_0__ = 0; k_0__ < theta_k_0_max__; ++k_0__) {
            vars__.push_back(theta[k_0__]);
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 131;
            validate_non_negative_index("eta", "(k - 1)", (k - 1));
            Eigen::Matrix<double, Eigen::Dynamic, 1> eta((k - 1));
            stan::math::initialize(eta, DUMMY_VAR__);
            stan::math::fill(eta, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 132;
            for (int i = 1; i <= (k - 1); ++i) {
                current_statement_begin__ = 132;
                stan::model::assign(eta, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(weights, (k - i), "weights", 1) / get_base1(weights, (k - 1), "weights", 1)), 
                            "assigning variable eta");
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t eta_j_1_max__ = (k - 1);
                for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
                    vars__.push_back(eta(j_1__));
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 158;
            validate_non_negative_index("log_lik_marginal", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> log_lik_marginal(N);
            stan::math::initialize(log_lik_marginal, DUMMY_VAR__);
            stan::math::fill(log_lik_marginal, DUMMY_VAR__);
            current_statement_begin__ = 159;
            validate_non_negative_index("log_lik", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> log_lik(N);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 161;
            for (int n = 1; n <= N; ++n) {
                current_statement_begin__ = 162;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            psma_normal_maxi_lpdf(get_base1(yi, n, "yi", 1), get_base1(theta, n, "theta", 1), stan::math::sqrt(get_base1(vi, n, "vi", 1)), alpha, eta, pstream__), 
                            "assigning variable log_lik");
            }
            current_statement_begin__ = 164;
            for (int n = 1; n <= N; ++n) {
                current_statement_begin__ = 165;
                stan::model::assign(log_lik_marginal, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            psma_normal_marginal_lpdf(get_base1(yi, n, "yi", 1), theta0, tau, stan::math::sqrt(get_base1(vi, n, "vi", 1)), alpha, eta, pstream__), 
                            "assigning variable log_lik_marginal");
            }
            // validate, write generated quantities
            current_statement_begin__ = 158;
            size_t log_lik_marginal_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < log_lik_marginal_j_1_max__; ++j_1__) {
                vars__.push_back(log_lik_marginal(j_1__));
            }
            current_statement_begin__ = 159;
            size_t log_lik_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                vars__.push_back(log_lik(j_1__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_psma";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "theta0";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau";
        param_names__.push_back(param_name_stream__.str());
        size_t weights_j_1_max__ = (k - 1);
        for (size_t j_1__ = 0; j_1__ < weights_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "weights" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t theta_k_0_max__ = N;
        for (size_t k_0__ = 0; k_0__ < theta_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t eta_j_1_max__ = (k - 1);
            for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "eta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t log_lik_marginal_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < log_lik_marginal_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik_marginal" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t log_lik_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "theta0";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau";
        param_names__.push_back(param_name_stream__.str());
        size_t weights_j_1_max__ = (k - 1);
        for (size_t j_1__ = 0; j_1__ < weights_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "weights" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t theta_k_0_max__ = N;
        for (size_t k_0__ = 0; k_0__ < theta_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t eta_j_1_max__ = (k - 1);
            for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "eta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t log_lik_marginal_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < log_lik_marginal_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik_marginal" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t log_lik_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_psma_namespace::model_psma stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
