% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{gpuff}
\alias{gpuff}
\title{Gaussian Puff Concentration Calculation}
\usage{
gpuff(Q, stab_class, x_p, y_p, x_r_vec, y_r_vec, z_r_vec, total_dist, H, U)
}
\arguments{
\item{Q}{Numeric. Mass per puff. E.g., for 100 puffs/hour of a 100 kg/hr emission, put 1 kg of mass into each puff.}

\item{stab_class}{Character vector. Stability class ("A" to "F").}

\item{x_p}{Numeric. Puff position in the X direction.}

\item{y_p}{Numeric. Puff position in the Y direction.}

\item{x_r_vec}{Numeric vector. The x-coordinate (east-west) where the concentration is calculated.}

\item{y_r_vec}{Numeric vector. The y-coordinate (north-south) where the concentration is calculated.}

\item{z_r_vec}{Numeric vector. The z-coordinate (height) where the concentration is calculated.}

\item{total_dist}{Numeric. The total distance the puff has traveled from the source in m.}

\item{H}{Numeric. Source height.}

\item{U}{Numeric. Wind speed in m/s.}
}
\value{
Numeric. Pollutant concentration at the specified (x, y, z) locations and time `t`.
}
\description{
Calculates the concentration of an emission event at a specified location and time due to a Gaussian puff.

This function uses wind speed and direction components, advection adjustments, and stability class calculations to
  accurately measure the dispersion of a puff in the atmosphere.
}
\examples{
out <- gpuff(Q = 1, stab_class = "D", x_p = 0, y_p = 0,
  x_r_vec = 100, y_r_vec = 0, z_r_vec = 2,
  total_dist = 100, H = 2, U = 5
)
}
