% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/puls.R
\name{splitter}
\alias{splitter}
\title{Split Function}
\usage{
splitter(
  toclust.fd,
  split_row,
  frame,
  cloc,
  dist,
  dsubs,
  dsubsname,
  weights,
  method
)
}
\arguments{
\item{toclust.fd}{A functional data object (i.e., having class \code{fd}) created
from \code{fda} package. See \code{\link[fda:fd]{fda::fd()}}.}

\item{split_row}{The row index in frame that would be split on.}

\item{frame}{The split tree transferred as data frame.}

\item{cloc}{Vector of current cluster membership.}

\item{dist}{Distance matrix of all observations in the data.}

\item{dsubs}{Distance matrix calculated on each subregion. A
three-dimensional matrix.}

\item{dsubsname}{Subregion names.}

\item{weights}{(Currently unused) Weights on observations.}

\item{method}{The clustering method you want to run in each subregion. Can be
chosen between \code{pam} and \code{ward}.}
}
\value{
Updated \code{frame} and \code{cloc} saved in a list.
}
\description{
Given the Cluster's frame's row position to split at \code{split_row}, this
function performs the split, calculate all necessary information for the
splitting tree and cluster memberships.
}
\keyword{internal}
