% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_protein_sequence.R
\name{check_protein_sequence}
\alias{check_protein_sequence}
\title{Check one protein sequence}
\usage{
check_protein_sequence(protein_sequence)
}
\arguments{
\item{protein_sequence}{a protein sequence, with
the amino acids as capitals, for
example \code{MEILCEDNTSLSSIPNSL}.
Use \link{check_protein_sequence} to check if
a protein sequence is valid.}
}
\value{
nothing.
Will \link{stop} if the protein sequence is invalid,
with a helpful error message.
}
\description{
Will \link{stop} if the protein sequence is invalid,
with a helpful error message.
}
\details{
A protein sequence is invalid if:
\itemize{
\item it has zero, two or more sequences
\item the sequence contains zero, 1 or 2 amino acids
\item the sequence contains characters that are not in the
amino acid uppercase alphabet,
that is \code{ACDEFGHIKLMNPQRSTVWY}
}
}
\examples{
check_protein_sequence("FAMILYVW")
}
