% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_pureseqtm_proteome_file.R
\name{create_pureseqtm_proteome_file}
\alias{create_pureseqtm_proteome_file}
\title{Create the output file of a PureseqTM proteome run}
\usage{
create_pureseqtm_proteome_file(
  fasta_filename,
  topology_filename = tempfile(fileext = ".top"),
  folder_name = get_default_pureseqtm_folder()
)
}
\arguments{
\item{fasta_filename}{path to a FASTA file}

\item{topology_filename}{name of the file to save a protein's
topology to}

\item{folder_name}{superfolder of PureseqTM.
The superfolder's name is \code{/home/[user_name]/.local/share}
by default, as can be obtained by
\link{get_default_pureseqtm_folder}}
}
\value{
the filename
}
\description{
Create the output file of a PureseqTM proteome run
}
\examples{

if (is_pureseqtm_installed()) {
  fasta_filename <- get_example_filename("1bhaA.fasta")
  create_pureseqtm_proteome_file(fasta_filename)
}
}
\author{
Richèl J.C. Bilderbeek
}
