% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StomatalClosure.R
\name{StomatalClosure}
\alias{StomatalClosure}
\title{Point of stomatal closure}
\usage{
StomatalClosure(data, sample = "sample",
  time.since.start = "time.since.start", conductance = "conductance",
  RWD = "RWD.interval", threshold = FALSE, graph = TRUE,
  show.legend = TRUE)
}
\arguments{
\item{data}{data frame containing columns of equal length giving the numerical
coordinates of the curve: time since start (minutes), conductance (mmol m^-2 s^-1) and RWD (\%), ordered by sample by ascending
time since start. A column containing the sample IDs is optionally required if several samples were measured.}

\item{sample}{optional name of the column in data containing the sample ID (if available), default: "sample"}

\item{time.since.start}{optional name of the column in data containing numeric time since start values (min), default: "time.since.start"}

\item{conductance}{optional name of the column in data containing numeric leaf conductance values (mmol m^-2 s^-1), default: "conductance"}

\item{RWD}{optional name of the column in data containing numeric relative water deficit (\%) values, default: "RWD.interval" (RWD average
of an interval as outputted by RWDInterval)}

\item{threshold}{sensitivity for the determination of stomatal closure. 60 by default.}

\item{graph}{set FALSE if no plots are to be returned}

\item{show.legend}{set FALSE if no legend is to be be shown in the plots}
}
\value{
List splitted by sample consisting of
\item{stomatal.closure}{coordinates of the point of stomatal closure (time.since.start, RWD, conductance)}
\item{formula}{formula of the exponential and linear part of the combined fits}
\item{coef}{coefficients of combined model}
\item{conf_int}{upper (97.5 \%) and lower (2.5 \%) border of 95 \% confidence interval of model parameters}
If graph = TRUE, the plotted original data is displayed with the exponential and
linear fit of the combined model as well as the x-coordinate (time.since.start) of the point of stomatal closure.
}
\description{
Determines the point of stomatal closure in a set of experimentally obtained leaf drying curves.
Stomatal closure happens when the curve irreversibly settles to linear water loss.
}
\details{
Before using this function, check the raw data for an initial plateau. If the exponential decline does not onset directly,
fitting might not succeed. \cr
The conductances by time since start curves are fitted using the Gauss-Newton algorithm of nls() to a
combined exponential and linear model. The exponential and linear parts are extracted and time since start at stomatal closure is
localized at the point where the slope of the exponential part of the fit is higher than a threshold value. The threshold value
is calculated by the use of the parameter b of the exponential part of the fit
(a * exp(b * x)): -(b^2 * sens). The sensitivity constant (sens) is 60 by default and can be specified individually by the argument
'threshold'. \cr
Minimum conductance (gmin) at stomatal closure is the conductance value of the overall fit at stomatal closure.
RWD at stomatal closure is then calculated by linear regression of RWD and time since start.
}
\examples{
# get example data
df <- WeatherAllocation(leaf_drying_data, weather_data)   # allocate weather to weight loss data
df <- TimeSinceStart(df) # calculate time since start
df <- df[df$fw.plateau != "yes",] # remove plateauing data
df <- FittedFW(df, graph = FALSE) # correct noises in fresh weight
df <- RWDInterval(df, fresh.weight = "fitted.fw") # calculate RWD based in the intervals
df <- Conductance(df, fresh.weight = "fitted.fw") # calculate conductance

# identify stomatal closure in curve and get graphs
sc <- StomatalClosure(df)

}
