% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwsem.R
\name{generalized.covariance}
\alias{generalized.covariance}
\title{Generalized covariance function}
\usage{
generalized.covariance(R1, R2)
}
\arguments{
\item{R1}{a numerical vector of residuals}

\item{R2}{a second numerical vector of residuals}
}
\value{
A list containing T.stat (the test statistic) and prob
(asymptotic null probability of the T statistic).
}
\description{
This function calculates the generalized covariance statistic of
Shah, R.D. & Peters, J. (2020); i.e. Y1 \emph{|} Y2 |C, where C is a set of
common conditioning variables. R1 and R2 are the response residuals
from pairs of regressions of two dependent variables (Y1 and Y2) on
a set of conditioning variables.

Shah, R.D. & Peters, J. (2020). The hardness of conditional independence
testing and the generalized covariance measure.  The Annals of Statistics
48:1514-1538.
}
\examples{
#generalized.covariance function: X1_|_X3|{X2}
R1<-residuals(mgcv::gam(X3~X2,data=sim_normal.no.nesting,family=gaussian),
type="response")
R2<-residuals(mgcv::gam(X1~X2,data=sim_normal.no.nesting,family=gaussian),
type="response")
generalized.covariance(R1,R2)

}
