% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pxweb_test_api_endpoint.R
\name{pxweb_test_api}
\alias{pxweb_test_api}
\title{Test a full or a part of a PXWEB api.}
\usage{
pxweb_test_api(
  url,
  test_type = "first",
  n = 1,
  verbose = TRUE,
  time_limit = Inf
)
}
\arguments{
\item{url}{The base url to the pxweb api (or a branch of the metadata tree)}

\item{test_type}{What type of test should be done.
The \code{first} observation of each table.
A random \code{sample} of size \code{n}.
Download all \code{full} tables.
\code{touch} the api by only downloading the first table metadata.
This is minimal testing of the API.}

\item{n}{sample size if \code{test_type} is \code{sample}.}

\item{verbose}{The function will print information.}

\item{time_limit}{Time limit in second the API is allowed to be tested.}
}
\value{
Function returns a data.frame with information on each node
Two variables are added:
\code{checked} : The node has been checked
\code{error} : Whether there were errors encountered with the call
\code{download_error} : Whether there were errors encountered during download
}
\description{
The function can be used to test a whole pxweb api by using the api base url.
By using a branch in a tree the api is tested below this branch.
}
\examples{
\dontrun{
url <- "https://bank.stat.gl/api/v1/en/Greenland/BE/BE01"
res <- pxweb_test_api(url)
res <- pxweb_test_api(url, test_type = "touch")
}
}
