% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DisableHIT.R
\name{DisableHIT}
\alias{DisableHIT}
\alias{DisposeHIT}
\alias{ExpireHIT}
\alias{DeleteHIT}
\alias{disablehit}
\alias{disposehit}
\alias{deletehit}
\title{Disable/Expire or Delete HIT}
\usage{
DisableHIT(
  hit = NULL,
  hit.type = NULL,
  annotation = NULL,
  approve.pending.assignments = FALSE,
  skip.delete.prompt = FALSE,
  verbose = getOption("pyMTurkR.verbose", TRUE)
)
}
\arguments{
\item{hit}{A character string containing a HITId or a vector of character
strings containing multiple HITIds. Must specify \code{hit} xor
\code{hit.type} xor \code{annotation}.}

\item{hit.type}{An optional character string containing a HITTypeId (or a
vector of HITTypeIds). Must specify \code{hit} xor \code{hit.type} xor
\code{annotation}.}

\item{annotation}{An optional character string specifying the value of the
\code{RequesterAnnotation} field for a batch of HITs. This can be used to
disable all HITs from a \dQuote{batch} created in the online Requester User
Interface (RUI). To use a batch ID, the batch must be written in a character
string of the form \dQuote{BatchId:78382;}, where \dQuote{73832} is the
batch ID shown in the RUI. Must specify \code{hit} xor \code{hit.type} xor
\code{annotation}.}

\item{approve.pending.assignments}{A logical indicating whether the pending
assignments should be approved when the HIT is disabled.}

\item{skip.delete.prompt}{A logical indicating whether to skip the prompt that
asks you to confirm the delete operation. If TRUE, you will not be asked to
confirm that you wish to Delete the HITs. The prompt is a safeguard flag to protect
the user from mistakenly deleting HITs.}

\item{verbose}{Optionally print the results of the API request to the
standard output. Default is taken from \code{getOption('pyMTurkR.verbose',
TRUE)}.}
}
\value{
A data frame containing a list of HITs and whether the request to
disable each of them was valid.
}
\description{
This function will allow you to expire a HIT early, which means it will no
longer be available for new workers to accept. Optionally, when disabling the
HIT you can approve all pending assignments and you can also try to delete
the HIT.
}
\details{
Be careful when deleting a HIT: this will also delete the assignment
data! Calling this function with \code{DeleteHIT()}, \code{deletehit()},
\code{DisposeHIT()}, or \code{disposehit()} will result in deleting the HIT.
The user will be prompted before continuing, unless \code{skip.delete.prompt}
is TRUE.

If you disable a HIT while workers are still working on an assignment, they
will still be able to complete their task.

\code{DisposeHIT()}, \code{ExpireHIT()}, \code{DeleteHIT()}, \code{disablehit()},
\code{disposehit()}, \code{expirehit()}, \code{deletehit()} are aliases.
}
\examples{

\dontrun{
# Disable a single HIT
hittype1 <- RegisterHITType(title = "10 Question Survey",
                description = "Complete a 10-question survey",
                reward = ".20",
                duration = seconds(hours=1),
                keywords = "survey, questionnaire, politics")
a <- GenerateExternalQuestion("https://www.example.com/", "400")
hit1 <- CreateHIT(hit.type = hittype1$HITTypeId,
                 assignments = 1,
                 expiration = seconds(days=1),
                 question = a$string)

DisableHIT(hit = hit1$HITId)

# Disable all HITs of a given HITType
DisableHIT(hit.type = hit1$HITTypeId)

# Disable all HITs of a given batch from the RUI
DisableHIT(annotation="BatchId:78382;")

# Delete the HIT previously disabled
DeleteHIT(hit = hit1$HITId)
}

}
\references{
\href{https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateExpirationForHITOperation.html}{API Reference: Update Expiration for HIT}
\href{https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteHITOperation.html}{API Reference: Delete HIT}
}
\author{
Tyler Burleigh, Thomas J. Leeper
}
\keyword{HITs}
