% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.fdqcd.R
\name{plot.fdqcd}
\alias{plot.fdqcd}
\title{Plot method for 'fdqcd' objects}
\usage{
\method{plot}{fdqcd}(x, y = NULL, title = NULL, xlab = NULL, ylab = NULL, col = NULL, ...)
}
\arguments{
\item{x}{Object fdqcd (pashe I)}

\item{y}{Object fdqcd (monitoring)}

\item{title}{an overall title for the plot}

\item{xlab}{a title for the x axis}

\item{ylab}{a title for the y axis}

\item{col}{The color for curves}

\item{...}{arguments to be passed to or from methods.}
}
\description{
Generic function for plotting Multivarite charts of object of class 'fdqcd' to perform statistical 
quality control.
}
\examples{
library(qcr)
m <- 30
tt<-seq(0,1,len=m)
mu<-30 * tt * (1 - tt)^(3/2)
n0 <- 100
set.seed(12345)
mdata<-matrix(NA,ncol=m,nrow=n0)
sigma <- exp(-3*as.matrix(dist(tt))/0.9)
for (i in 1:n0) mdata[i,]<- mu+0.5*mvrnorm(mu = mu,Sigma = sigma )
fdchart <- fdqcd(mdata)
plot(fdchart,type="l",col="gray")
}
