% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{range_qfr}
\alias{range_qfr}
\alias{gen_eig}
\title{Get range of ratio of quadratic forms}
\usage{
range_qfr(
  A,
  B,
  eigB = eigen(B, symmetric = TRUE),
  tol = .Machine$double.eps * 100,
  t = 0.001
)

gen_eig(
  A,
  B,
  eigB = eigen(B, symmetric = TRUE),
  Ad = with(eigB, crossprod(crossprod(A, vectors), vectors)),
  tol = .Machine$double.eps * 100,
  t = 0.001
)
}
\arguments{
\item{A, B}{Symmetric matrices.  No check is done.}

\item{eigB}{Result of \code{eigen(B)} can be passed when already computed}

\item{tol}{Tolerance to determine numerical zero}

\item{t}{Tolerance used to determine whether estimates are numerically stable;
\eqn{t} in Jennings et al. (1978).}

\item{Ad}{\code{A} rotated with eigenvectors of \code{B} can be passed
when already computed}
}
\description{
\code{range_qfr()}: internal function to obtain the possible range of
a ratio of quadratic forms,
\eqn{\frac{ \mathbf{x^{\mathit{T}} A x} }{ \mathbf{x^{\mathit{T}} B x} }
}{ (x^T A x) / (x^T B x) }.

\code{gen_eig()} is an internal function to obtain generalized eigenvalues,
i.e., roots of
\eqn{\det{\mathbf{A} - \lambda \mathbf{B}} = 0}{A - \lambda B = 0},
which are the eigenvalues of \eqn{\mathbf{B}^{-1} \mathbf{A}} if
\eqn{\mathbf{B}} is nonsingular.
}
\details{
\code{gen_eig()} solves the generalized eigenvalue problem with
Jennings et al.'s (1978) algorithm.  The sign of infinite eigenvalue
(when present) cannot be determined from this algorithm, so is deduced
as follows: (1) \eqn{\mathbf{A}}{A} and \eqn{\mathbf{B}}{B} are rotated by
the eigenvectors of \eqn{\mathbf{B}}{B}; (2) the submatrix of rotated
\eqn{\mathbf{A}}{A} corresponding to the null space of \eqn{\mathbf{B}}{B}
is examined; (3) if this is nonnegative (nonpositive) definite, the result
must have positive (negative, resp.) infinity; if this is indefinite,
the result must have both positive and negative infinities;
if this is (numerically) zero, the result must have \code{NaN}.  The last
case is expeted to happen very rarely, as in this case Jennings algorithm
would fail.  This is where the null space of \eqn{\mathbf{B}}{B} is
a subspace of that of \eqn{\mathbf{A}}{A}, so that the range of ratio of
quadratic forms can be well-behaved.  \code{range_qfr()} tries to detect
this case and handle the range accordingly, but if that is infeasible
it returns \code{c(-Inf, Inf)}.
}
\references{
Jennings, A., Halliday, J. and Cole, M. J. (1978) Solution of linear
generalized eigenvalue problems containing singular matrices.
\emph{Journal of the Institute of Mathematics and Its Applications}, \strong{22},
401--410.
\doi{10.1093/imamat/22.4.401}.
}
