% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve.R
\name{solveqp}
\alias{solveqp}
\title{Quadratic Programming}
\usage{
solveqp(
  H,
  h = NULL,
  lb = NULL,
  ub = NULL,
  A = NULL,
  Alb = NULL,
  Aub = NULL,
  pars = list()
)
}
\arguments{
\item{H}{Symmetric positive definite matrix, n*n. Can also be a (inverse) Cholesky factor cf.
\code{\link{qpmadParameters}}.}

\item{h}{\emph{Optional}, vector of length n.}

\item{lb, ub}{\emph{Optional}, lower/upper bounds of \code{x}. Will be repeated n times if length is one.}

\item{A}{\emph{Optional}, constraints matrix of dimension p*n, where each row corresponds to a constraint. For equality constraints let corresponding elements in \code{Alb} equal those in \code{Aub}}

\item{Alb, Aub}{\emph{Optional}, lower/upper bounds for \eqn{Ax}.}

\item{pars}{\emph{Optional}, qpmad-solver parameters, conveniently set with \code{\link{qpmadParameters}}}
}
\value{
At least one of \code{lb}, \code{ub} or \code{A} must be specified. If \code{A} has been
specified then also at least one of \code{Alb} or \code{Aub}. Returns a list with elements \code{solution} (the solution vector),
\code{status} (a status code) and \code{message} (a human readable message). If \code{status} = \code{0} the algorithm has converged.
Possible status codes:
\itemize{
  \item{\code{0}: Ok}
  \item{\code{-1}: Numerical issue, matrix (probably) not positive definite}
  \item{\code{1}: Inconsistent}
  \item{\code{2}: Infeasible equality}
  \item{\code{3}: Infeasible inequality}
  \item{\code{4}: Maximal number of iterations}
}
}
\description{
Solves
\deqn{argmin 0.5 x' H x + h' x}
s.t.
\deqn{lb_i \leq x_i \leq ub_i}{lb_i \le x_i \le ub_i}
\deqn{Alb_i \leq (A x)_i \leq Aub_i}{Alb_i \le (A x)_i \le Aub_i}
}
\examples{
## Assume we want to minimize: -(0 5 0) \%*\% b + 1/2 b^T b
## under the constraints:      A^T b >= b0
## with b0 = (-8,2,0)^T
## and      (-4  2  0)
##      A = (-3  1 -2)
##          ( 0  0  1)
## we can use solveqp as follows:
##
Dmat       <- diag(3)
dvec       <- c(0,-5,0)
Amat       <- t(matrix(c(-4,-3,0,2,1,0,0,-2,1),3,3))
bvec       <- c(-8,2,0)
solveqp(Dmat,dvec,A=Amat,Alb=bvec)
}
\seealso{
\code{\link{qpmadParameters}}
}
