% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/primer.R
\docType{data}
\name{primer}
\alias{primer}
\title{Automobile primer paint thickness quality control measurements.}
\format{A data frame with 20 rows and 14 variates:
\describe{
  \item{day}{Day on which the parts were taken and measured.}
  \item{batch}{Either the first or second set of 10 consecutive parts taken.}
  \item{sel1}{Thickness of primer in mils on the first part sampled in the specified batch of that day.}
  \item{sel2}{Thickness of primer in mils on the second part sampled in the specified batch of that day.}
  \item{sel3}{Thickness of primer in mils on the third part sampled in the specified batch of that day.}
  \item{sel4}{Thickness of primer in mils on the fourth part sampled in the specified batch of that day.}
  \item{sel5}{Thickness of primer in mils on the fifth part sampled in the specified batch of that day.}
  \item{sel6}{Thickness of primer in mils on the sixth part sampled in the specified batch of that day.}
  \item{sel7}{Thickness of primer in mils on the seventh part sampled in the specified batch of that day.}
  \item{sel8}{Thickness of primer in mils on the eighth part sampled in the specified batch of that day.}
  \item{sel9}{Thickness of primer in mils on the ninth part sampled in the specified batch of that day.}
  \item{sel10}{Thickness of primer in mils on the tenth part sampled in the specified batch of that day.}
  \item{xbar}{Arithmetic average of the measurements of primer thickness of the 10 parts selected in the specified batch of that day.}
  \item{s}{Sample standard deviation of the measurements of primer thickness of the 10 parts selected in the specified batch of that day.}
}}
\source{
"Statistical Process Control - SPC", 
Automotive Industry Action Group(AIAG), Southfield MI,  (1995), page 64.
}
\usage{
primer
}
\description{
Contains process control measurements of thickness of primer applied to
automotive body parts in an auto factory.
Twice daily, a set of 10 consecutive parts were selected and the thickness in mils (thousandths of an inch)
were measured.  For each set of 10 parts, the average (xbar) and the sample standard deviation (s) were also
calculated and recorded.  These summaries would be plotted in xbar or s control charts with suitably determined upper and
lower control limits.
Alternatively, for checking outliers a qqplot (via qqtest) could be used for either xbar or s.
}
\details{
\code{with(primer,qqtest(xbar, main="Averages"))} will effect this plot for xbar.
\code{with(primer,qqtest(s,dist="kay", df=9, main ="Standard deviations"))} will effect this plot for s.
}
\keyword{datasets}
