% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/laplace_pseudo_target.R
\name{lapprox}
\alias{lapprox}
\title{Pseudo-target from Laplace Approximation}
\usage{
lapprox(
  log_target,
  init,
  family = "t",
  params = NULL,
  sc_adj = 1,
  lb = -Inf,
  ub = Inf,
  maxit = 100,
  ...
)
}
\arguments{
\item{log_target}{Univariate function evaluating the unnormalized log density to approximate.}

\item{init}{Numeric scalar for an initial value (used in optimization).}

\item{family}{String specifying the family of distributions for the pseudo-target.
Can be any of the families accepted by \link[qslice]{pseudo_list}.}

\item{params}{List specifying the parameters for the pseudo-target to be used.
The location and scale parameters will be replaced with the Laplace approximation and
others (e.g., degrees of freedom) will be retained.}

\item{sc_adj}{Positive numeric scalar; manual multiplicative adjustment to the
scale of the output pseudo-target.}

\item{lb}{Numeric scalar giving the value of left truncation of the resulting pseudo-target.
Defaults to \code{-Inf}.}

\item{ub}{Numeric scalar giving the value of right truncation of the resulting pseudo-target.
Defaults to \code{Inf}.}

\item{maxit}{See \link[stats]{optim}.}

\item{...}{See \link[stats]{optim}.}
}
\value{
A list with the same outputs as \link[qslice]{pseudo_list}; also includes
\code{opt}, which gives output of \link[stats]{optim}.
}
\description{
Find the location and scale for an approximating pseudo-target via Laplace
approximation.
}
\examples{
pseu <- lapprox(function(x) dnorm(x, log = TRUE),
  family = "t",
  params = list(loc = NA, sc = NA, degf = 5.0),
  init = 0.5, lb = -1.0)
curve(dnorm(x)/(1- pnorm(-1)), from = -1, to = 6, col = "blue")
xx <- seq(-1, 6, length = 500)
lines(xx, sapply(xx, FUN = pseu$d))
}
