% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_shrinkslice.R
\name{utility_pseudo}
\alias{utility_pseudo}
\title{Utility for a given target and pseudo-target}
\usage{
utility_pseudo(
  pseudo,
  log_target = NULL,
  samples = NULL,
  type = "samples",
  x = NULL,
  nbins = 30,
  plot = TRUE,
  utility_type = "AUC",
  tol_int = 0.001
)
}
\arguments{
\item{pseudo}{List containing the following functions with scalar input:

\code{ld}: function to evaluate the log density

\code{q}: function to evaluate the quantile function

\code{p}: function to evaluate the distribution function}

\item{log_target}{Function to evaluate the log density of the unnormalized target.}

\item{samples}{Numeric vector of samples from the target distribution.}

\item{type}{String specifying the input type. One of "function", "samples", or "grid".
Default is to use "samples".

Use of "function" requires specification of \code{log_target}.

Use of "samples" requires specification of \code{samples}.

Use of "grid" requires specification of \code{x}.}

\item{x}{Numeric vector specifying grid (on (0,1)) over which to evaluate
the transformed target. Defaults to \code{NULL}.}

\item{nbins}{Number of histogram bins to use (defaults to 30). Must match the length
of \code{x} if \code{x} is supplied.}

\item{plot}{Logical for whether to generate two plots:
\enumerate{
\item direct comparison of the target and pseudo-target densities, and
\item transformed target density.
}

Defaults to \code{TRUE}.}

\item{utility_type}{String identifying utility type, either AUC (default) or MSW.}

\item{tol_int}{Positive numeric scalar that passes to \code{abs.tol} in the call to \link[stats]{integrate}.
Defaults to \code{1.0e-3}.}
}
\value{
Scalar value of the utility function evaluation.
}
\description{
Takes a pseudo-target and target (or samples from the target) and
evaluates the utility function for the transformed target, which can be one of
Area Under the Curve (AUC) and Mean Slice Width (MSW). See Heiner et al. (2024+).
}
\details{
Optionally plot the target and pseudo-target densities as well as the
transformed tartet.
}
\examples{
pseu <- pseudo_list(family = "logistic", params = list(loc = 0.0, sc = 0.66))
ltarg <- list(ld = function(x) dnorm(x, log = TRUE))
oldpar <- par(mfrow = c(1,2))
utility_pseudo(pseudo = pseu, log_target = ltarg$ld, type = "function",
               nbins = 100, utility_type = "MSW")
samp <- rnorm(10e3)
utility_pseudo(pseudo = pseu, samples = samp, type = "samples", utility_type = "AUC")
utility_pseudo(pseudo = pseu, samples = samp, type = "samples", utility_type = "MSW")
par(oldpar)

}
\references{
Heiner, M. J., Johnson, S. B., Christensen, J. R., and Dahl, D. B. (2024+), "Quantile Slice Sampling," \emph{arXiv preprint arXiv:###}.
}
