% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symmetricPolynomials.R
\name{HallInnerProduct}
\alias{HallInnerProduct}
\title{Hall inner product}
\usage{
HallInnerProduct(qspray1, qspray2, alpha = 1)
}
\arguments{
\item{qspray1, qspray2}{two symmetric \code{qspray} polynomials}

\item{alpha}{parameter equal to \code{1} for the usual Hall inner product, 
otherwise this is the "Jack parameter"; it must be either a single value 
coercible to a \code{bigq} number, e.g. \code{"2/5"}, or \code{NULL} to 
get the Hall product with a symbolic \code{alpha}}
}
\value{
A \code{bigq} number if \code{alpha} is not \code{NULL}, otherwise 
  a univariate \code{qspray} polynomial.
}
\description{
Hall inner product of two symmetric polynomials. It has a 
  parameter \code{alpha} and the standard Hall inner product is the case 
  when \code{alpha=1}. It is possible to get the Hall inner product with 
  a symbolic \code{alpha} parameter.
}
