% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symmetricPolynomials.R
\name{PSPcombination}
\alias{PSPcombination}
\title{Symmetric polynomial as a linear combination of some power sum 
  polynomials}
\usage{
PSPcombination(qspray)
}
\arguments{
\item{qspray}{a symmetric \code{qspray} polynomial; symmetry is not checked}
}
\value{
A list of pairs. Each pair is made of a \code{bigq} number, the 
  coefficient of the term of the linear combination, and an integer 
  partition, corresponding to a power sum polynomial.
}
\description{
Expression of a symmetric \code{qspray} polynomial as a 
  linear combination of some power sum polynomials.
}
\examples{
# take a symmetric polynomial
( qspray <- ESFpoly(4, c(2, 1)) + ESFpoly(4, c(2, 2)) )
# compute the power sum combination
( pspCombo <- PSPcombination(qspray) )
# then the polynomial can be reconstructed as follows:
Reduce(`+`, lapply(pspCombo, function(term) {
  term[["coeff"]] * PSFpoly(4, term[["lambda"]])
}))
}
\seealso{
\code{\link{PSPexpression}}.
}
