% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queries.R
\docType{methods}
\name{getCoefficient}
\alias{getCoefficient}
\alias{getCoefficient,qspray,numeric-method}
\title{Get a coefficient in a 'qspray' polynomial}
\usage{
\S4method{getCoefficient}{qspray,numeric}(qspray, exponents)
}
\arguments{
\item{qspray}{a \code{qspray} object}

\item{exponents}{a vector of exponents, thereby defining a monomial;
trailing zeros are ignored}
}
\value{
The coefficient as a \code{bigq} number.
}
\description{
Get the coefficient of the term with the given monomial.
}
\examples{
library(qspray)
x <- qlone(1)
y <- qlone(2)
p <- 4*x^2 + 3*y - 5
getCoefficient(p, 2)          # coefficient of x^2
getCoefficient(p, c(2, 0))    # same as getCoefficient(p, 2)
getCoefficient(p, c(0, 1))    # coefficient of y because y=x^0*y^1
getCoefficient(p, 0)          # the constant term
getCoefficient(p, integer(0)) # the constant term 
getCoefficient(p, 3)          # there's no x^3
}
