% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show.R
\name{showMonomialXYZ}
\alias{showMonomialXYZ}
\title{Print a monomial}
\usage{
showMonomialXYZ(letters = c("x", "y", "z"), collapse = ".")
}
\arguments{
\item{letters}{a vector of strings, usually some letters such as \code{"x"} 
and \code{"y"}, to denote the variables}

\item{collapse}{a string to denote the symbol representing the 
multiplication, e.g. \code{"*"} or \code{"."}}
}
\value{
A function which takes as argument a sequence of exponents and 
  which prints the corresponding monomial.
}
\description{
Prints a monomial like \code{"x.z^2"} if possible (see details).
}
\details{
If the function returned by this function is applied to a vector 
  of exponents whose length is higher than the length of the \code{letters} 
  vector, then \code{\link{showMonomialX1X2X3}(x=letters[1])} is applied 
  (see the last example).
}
\note{
The function returned by this function can be used as the option 
  \code{"showMonomial"} in the \code{\link{showQsprayOption<-}} function.
}
\examples{
showMonomialXYZ()(c(1, 0, 2))
showMonomialXYZ(collapse = "*")(c(1, 0, 2))
showMonomialXYZ()(NULL)
# what happens if there are more exponents than letters:
showMonomialXYZ(c("a", "b"), collapse = "*")(c(1, 2, 3))
# same as:
showMonomialX1X2X3("a", collapse = "*")(c(1, 2, 3))
# setting a show option:
set.seed(3141)
( qspray <- rQspray() )
showQsprayOption(qspray, "showMonomial") <- showMonomialXYZ(c("A", "B", "C"))
qspray
# this is equivalent to:
showQsprayOption(qspray, "showQspray") <- showQsprayXYZ(c("A", "B", "C"))
}
\seealso{
\code{\link{showQsprayXYZ}}, 
  \code{\link{showMonomialX1X2X3}}, \code{\link{showQsprayOption<-}}.
}
