% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interp_map.R
\name{interp_map}
\alias{interp_map}
\title{Interpolate between maps}
\usage{
interp_map(map, oldmap, newmap)
}
\arguments{
\item{map}{The map to be interpolated; a list of vectors.}

\item{oldmap}{Map with positions in the original scale, as in \code{map}.}

\item{newmap}{Map with positions in the new scale.}
}
\value{
Object of same form as input \code{map} but in the units as in \code{newmap}.
}
\description{
Use interpolate to convert from one map to another
}
\examples{
# load example data
iron <- read_cross2(system.file("extdata", "iron.zip", package="qtl2"))

# positions to interpolate from cM to Mbp
tointerp <- list("7" = c(pos7.1= 5, pos7.2=15, pos7.3=25),
                 "9" = c(pos9.1=20, pos9.2=40))

interp_map(tointerp, iron$gmap, iron$pmap)

}
