% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_vector.R
\name{as_vector}
\alias{as_vector}
\alias{as_vector,Quadtree-method}
\title{Get all \code{Quadtree} cell values as a vector}
\usage{
\S4method{as_vector}{Quadtree}(x, terminal_only = TRUE)
}
\arguments{
\item{x}{a \code{\link{Quadtree}}}

\item{terminal_only}{boolean; if \code{TRUE} (the default) only values of
terminal cells are returned. If \code{FALSE}, all cell values are returned.}
}
\value{
a numeric vector
}
\description{
Returns all cell values  of a \code{\link{Quadtree}} as a
  numeric vector.
}
\examples{
library(quadtree)
habitat <- terra::rast(system.file("extdata", "habitat.tif", package="quadtree"))

qt <- quadtree(habitat, .2)
head(as_vector(qt), 20)
head(as_vector(qt, FALSE), 20)
}
\seealso{
\code{\link{as_data_frame}} creates a data frame from a
  \code{\link{Quadtree}} that has all the cell values as well as details
  about each cell's size and extent.
}
