% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lcp.R
\name{find_lcps}
\alias{find_lcps}
\alias{find_lcps,LcpFinder-method}
\title{Find LCPs to surrounding points}
\usage{
\S4method{find_lcps}{LcpFinder}(x, limit = NULL, return_summary = TRUE)
}
\arguments{
\item{x}{a \code{\link{LcpFinder}}}

\item{limit}{numeric; the maximum cost-distance for the LCPs. If \code{NULL}
(the default), no limit is applied and all possible LCPs (within the
\code{LcpFinder}'s search area) are found}

\item{return_summary}{boolean; if \code{TRUE} (the default),
\code{\link{summarize_lcps}()} is used to return a summary matrix of all
paths found. If \code{FALSE}, no value is returned.}
}
\value{
If \code{return_summary} is \code{TRUE},
  \code{\link{summarize_lcps}()} is used to return a matrix summarizing each
  LCP found. See the help page of that function for details on the return
  matrix. If \code{return_summary} is \code{FALSE}, no value is returned.
}
\description{
Calculates least-cost paths (LCPs) from the start point (the
  point used to create the \code{\link{LcpFinder}}) to surrounding points. A
  constraint can be placed on the LCPs so that only LCPs that are less than
  some specified cost-distance are returned.
}
\details{
Once the LCPs have been calculated, \code{\link{find_lcp}()} can be
  used to extract paths to individual points. No further calculation will be
  required to retrieve these paths so long as they were calculated when
  \code{find_lcps()} was run.

  A very important note to make is that once the LCP tree is calculated, it
  never gets smaller. For example, we could use \code{\link{find_lcps}()}
  with \code{limit = NULL} to calculate all LCPs. If we then used
  \code{\link{find_lcps}()} on the same \code{LcpFinder} but this time used a
  limit, it would still return \emph{all} of the LCPs, even those that are
  greater than the specified limit, since the tree never shrinks.
}
\examples{
####### NOTE #######
# see the "quadtree-lcp" vignette  for more details and examples:
# vignette("quadtree-lcp", package = "quadtree")
####################

library(quadtree)
habitat <- terra::rast(system.file("extdata", "habitat.tif", package="quadtree"))

qt <- quadtree(habitat, split_threshold = .1, adj_type = "expand")

start_pt <- c(19000, 25000)

# finds LCPs to all cells
lcpf1 <- lcp_finder(qt, start_pt)
paths1 <- find_lcps(lcpf1, limit = NULL)

# limit LCPs by cost-distance
lcpf2 <- lcp_finder(qt, start_pt)
paths2 <- find_lcps(lcpf2, limit = 5000)

# Now plot the reachable cells
plot(qt, crop = TRUE, na_col = NULL, border_lwd = .3)
points(lcpf1, col = "black", pch = 16, cex = 1)
points(lcpf2, col = "red", pch = 16, cex = .7)
points(start_pt[1], start_pt[2], bg = "skyblue", col = "black", pch = 24,
       cex = 1.5)
}
\seealso{
\code{\link{lcp_finder}()} creates the \code{\link{LcpFinder}}
  object used as input to this function. \code{\link{find_lcp}()} returns the
  LCP between the start point and another point.
  \code{\link{summarize_lcps}()} outputs a summary matrix of all LCPs that
  have been calculated so far.
}
