% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-extract.R
\name{qmd_to_r_script}
\alias{qmd_to_r_script}
\title{Convert Quarto document to R script}
\usage{
qmd_to_r_script(qmd, script = NULL)
}
\arguments{
\item{qmd}{Character. Path to the input Quarto document (.qmd file).}

\item{script}{Character. Path to the output R script file. If \code{NULL}
(default), the script file will have the same name as the input file
but with \code{.R} extension.}
}
\value{
Invisibly returns the path to the created R script file, or
\code{NULL} if no R code cells were found.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Extracts R code cells from a Quarto document and writes them to an R script
file that can be rendered with the same options. The Markdown text is not
preserved, but R chunk options are kept as comment headers using Quarto's
\verb{#|} syntax.

This function is still experimental and may slightly change in
future releases, depending on feedback.
}
\details{
This function processes a Quarto document by:
\itemize{
\item Extracting only R code cells (markdown and cell in other languages are ignored)
\item Preserving chunk options as \verb{#|} comment headers
\item Adding the document's YAML metadata as a spin-style header
\item Creating an R script that can be rendered with the same options
}
\subsection{Chunk option handling:}{
\itemize{
\item Chunks with \code{purl: false} are completely skipped and not included in the output
\item Chunks with \code{eval: false} have their code commented out (prefixed with \verb{# }) in the R script
\item All other chunk options are preserved as \verb{#|} comment headers
}
}

\subsection{File handling:}{
\itemize{
\item If the output R script already exists, the function will abort with an error
\item Non-R code cells (e.g., Python, Julia, Observable JS) are ignored
\item If no R code cells are found, the function does nothing and returns \code{NULL}
}
}

\subsection{Compatibility:}{

The resulting R script is compatible with Quarto's script rendering via
\code{knitr::spin()} and can be rendered directly with \verb{quarto render script.R}.
See \url{https://quarto.org/docs/computations/render-scripts.html#knitr} for
more details on rendering R scripts with Quarto.

The resulting R script uses Quarto's executable cell format with \verb{#|}
comments to preserve chunk options like \code{label}, \code{echo}, \code{output}, etc.

The resulting R script could also be \code{source()}d in R, as any \code{eval = FALSE} will be commented out.
}

\subsection{Limitations:}{

This function relies on static analysis of the Quarto document by \verb{quarto inspect}. This means that
any \pkg{knitr} specific options like \verb{child=} or specific feature like \code{\link[knitr:read_chunk]{knitr::read_chunk()}} are not supported.
They rely on tangling or knitting by \pkg{knitr} itself. For this support,
one should look at \code{\link[knitr:chunk_hook]{knitr::hook_purl()}} or \code{\link[knitr:knit]{knitr::purl()}}.
}
}
\examples{
\dontrun{
# Convert a Quarto document to R script
qmd_to_r_script("my-document.qmd")
# Creates "my-document.R"

# Specify custom output file
qmd_to_r_script("my-document.qmd", script = "extracted-code.R")
}

}
