% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{quarto_print}
\alias{quarto_print}
\alias{knit_print.quarto_object}
\alias{print.quarto_object}
\alias{print.quarto_div}
\alias{print.quarto_span}
\alias{print.quarto_tabset}
\alias{print.quarto_section}
\alias{print.quarto_group}
\alias{print.quarto_markdown}
\alias{knit_print.quarto_div}
\alias{knit_print.quarto_span}
\alias{knit_print.quarto_tabset}
\alias{knit_print.quarto_section}
\alias{knit_print.quarto_group}
\alias{knit_print.quarto_markdown}
\title{Print a quarto object}
\usage{
\method{knit_print}{quarto_object}(x, ...)

\method{print}{quarto_object}(x, ...)
}
\arguments{
\item{x}{A quarto object.}

\item{...}{Other arguments (ignored).}
}
\value{
\code{knitr::knit_print()} invisibly returns \code{NULL}; \code{print()}
invisibly returns the quarto object itself.
}
\description{
Prints a quarto object. When calling \code{knitr::knit_print()}
on a quarto object, the relevant \code{format()} method is called
first, and the formatted version is printed to the document.
When calling \code{print()}, a summary of the object structure is
printed.
}
\details{
There are two print methods supplied for quarto objects, one for
\code{base::print()} and another for \code{knitr::knit_print()}. The regular
print method behaves similarly to any other print method: it prints
a summary of the object to the R console, and invisibly returns the
object itself.

When \code{knitr::knit_print()} is called on a quarto object, the behavior
is quite different. The object is first passed to \code{format()}, which
constructs the required quarto syntax, then the object is printed
to the document (or console, if called interactively) using the
appropriate syntax. In this case, the function invisibly returns \code{NULL}.
}
\examples{
# a quarto_section object
sec <- quarto_section("A level-two header", level = 2L)
 
# base::print() displays a summary of the object 
print(sec)

# knitr::knit_print() displays the rendered quarto syntax
knitr::knit_print(sec) 

# a quarto_span object
spn <- quarto_span("This is underlined", class = "underline")

print(spn)

knitr::knit_print(spn)
 
}
