% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-helpers.R
\name{.plotGrob}
\alias{.plotGrob}
\title{Plot spatial grobs (using \pkg{grid} package)}
\usage{
.plotGrob(
  grobToPlot,
  col = NULL,
  real = FALSE,
  size = unit(5, "points"),
  minv,
  maxv,
  legend = TRUE,
  legendText = NULL,
  length = NULL,
  gp = gpar(),
  gpText = gpar(),
  pch = 19,
  speedup = 1,
  name = character(),
  vp = list(),
  ...,
  verbose = getOption("quickPlot.verbose")
)
}
\arguments{
\item{grobToPlot}{\verb{Raster*}, \verb{SpatialLines*},
\verb{SpatialPoints*}, or \verb{SpatialPolygons*} object.}

\item{col}{Currently only used for the legend of a \verb{Raster*} object.}

\item{real}{Logical indicating whether the data are \code{real} numbers
(i.e., as opposed to \code{integer} or \code{factor}).}

\item{size}{The size of the \code{SpatialPoints}.}

\item{minv}{The minimum value on a \verb{Raster*}. Required because not
all Rasters have this defined internally.}

\item{maxv}{The maximum value on a \verb{Raster*}. Required because not
all Rasters have this defined internally.}

\item{legend}{Logical indicating whether a legend should be drawn.
Default \code{TRUE}.}

\item{legendText}{Vector of values to use for legend value labels.
Defaults to \code{NULL} which results in a pretty numeric
representation. If \verb{Raster*} has a Raster Attribute
Table (rat; see \pkg{raster} package), this will be used
by default. Currently, only a single vector is accepted.}

\item{length}{Numeric.}

\item{gp}{\code{grid} parameters, usually the output of a call to \code{\link[=gpar]{gpar()}}.}

\item{gpText}{\code{gpar} object for legend label text.}

\item{pch}{Point character for \code{SpatialPoints}, as \code{par}.}

\item{speedup}{Numeric. The factor by which the number of vertices in
\code{SpatialPolygons} and \verb{SpatialLines*} will be
subsampled. The vertices are already subsampled by default to
make plotting faster.}

\item{name}{Character string of name of object being plotted.}

\item{vp}{whole viewport tree of \code{quickPlotGrob}}

\item{...}{Additional arguments. None currently implemented.}

\item{verbose}{Numeric or logical. If \code{TRUE} or \verb{>0}, then messages will be
shown. If \code{FALSE} or \code{0}, most messages will be suppressed.}
}
\description{
Internal function. Plot a raster Grob, a points Grob, polygon Grob.
}
\details{
\code{speedup} is only used for \code{SpatialPolygons}, \code{SpatialPoints},
and \code{SpatialLines} in this function.
Attempts have been made to subsample at a good level that optimizes speed of
plotting, without losing visible quality. Nevertheless, to force all points to
be plotted, use a speedup value less than 0.1.
Presumably, too much thinning requires large distance matrices to be
calculated, slowing plotting down.
Too little thinning causes an overabundance of points to be plotted, slowing
plotting down.
}
\author{
Eliot McIntire
}
\keyword{internal}
