% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shareButton.R
\name{shareButton}
\alias{shareButton}
\title{Add social buttons to share a page}
\usage{
shareButton(
  link,
  image = NULL,
  text = NULL,
  position = c("left", "right", "inline"),
  text.color = "black",
  plain = FALSE,
  facebook = TRUE,
  linkedin = TRUE,
  bg.col = NULL,
  x = FALSE,
  tumblr = FALSE,
  pinterest = FALSE,
  whatsapp = FALSE,
  reddit = FALSE,
  blogger = FALSE,
  weibo = FALSE,
  tiktok = FALSE,
  vk = FALSE,
  telegram = FALSE,
  visit.us = FALSE
)
}
\arguments{
\item{link}{the link to share on social media}

\item{image}{the image link to share on social media}

\item{text}{the text to share on social media}

\item{position}{of buttons e.g "left","right","bottom","inline"}

\item{text.color}{text color e.g black}

\item{plain}{logical. with or without background}

\item{facebook}{share on Facebook}

\item{linkedin}{share on Linkedin}

\item{bg.col}{background color for the icons.}

\item{x}{share on Twitter}

\item{tumblr}{share on Tumblr}

\item{pinterest}{share on Pinterest}

\item{whatsapp}{share on Whatsapp}

\item{reddit}{share on Reddit}

\item{blogger}{share on Blogger}

\item{weibo}{share on Weibo}

\item{tiktok}{share on Tiktok}

\item{vk}{share on VK or VKontakte}

\item{telegram}{share on Telegram}

\item{visit.us}{share on custom link}
}
\value{
Share link button via social media platforms
}
\description{
Customize social buttons available for sharing of pages
}
\note{
'bg.col' argument is only functional if 'plain' argument is set to false
}
\section{Examples for r2social}{

More examples and demo pages are located at this link -
\url{https://r2social.obi.obianom.com}.
}

\examples{
# Basic examples
# Let's make r2 social great again!
shareButton(link = "http://rpkg.net", position = "left")
shareButton(link = "http://obianom.com", position = "right")
shareButton(link = "https://shinyappstore.com/", plain = TRUE, position = "inline") #plain styling
shareButton(link = "https://shinyappstore.com/", plain = FALSE, position = "inline") #beautified

}
