% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetchByKeyCat.R
\name{symCat}
\alias{symCat}
\title{Fetch multiple symbols by category}
\usage{
symCat(
  category,
  font.size = NULL,
  font.weight = NULL,
  font.color = NULL,
  if.error = TRUE
)
}
\arguments{
\item{category}{symbol categories to fetch (minimum: 4 characters)}

\item{font.size}{font size as integer}

\item{font.weight}{font weight as integer}

\item{font.color}{font color e.g. red, blue, cyan}

\item{if.error}{show error response}
}
\value{
get symbols from matching a particular category
}
\description{
Fetch one or more symbols by category
}
\section{Categories include}{
 arrows mixed chess check mark symbol animal emoji flag people
skull sign star telephone weather zodiac smiley hourglass fraction cards triangle square
}

\examples{
symCat("arrows")
symCat("smiley", font.size = 32)
symCat("music")
symCat("random") # should not work

}
