% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eff_size_per_foils.R
\name{eff_size_per_foils}
\alias{eff_size_per_foils}
\title{Effective Size per Foils}
\usage{
eff_size_per_foils(lineup_vec, target_pos, k, conf = 0.95)
}
\arguments{
\item{lineup_vec}{A numeric vector of lineup choices}

\item{target_pos}{A numeric vector indexing all lineup members}

\item{k}{Number of members in lineup. Must be specified by user (scalar).}

\item{conf}{Desired level of alpha. Defaults to 0.95. May be specified by user (scalar).}
}
\description{
Function for computing effective size (Malpass, 1981) counting foils who fall
within the CI for chance guessing
}
\examples{
#Data:
lineup_vec <- round(runif(100, 1, 6))
target_pos <- c(1, 2, 3, 4, 5, 6)

#Call:
eff_size_per_foils(lineup_vec, target_pos, 6)
eff_size_per_foils(lineup_vec, target_pos, conf = 0.95, 6)
}
\references{
Malpass, R S. (1981). Effective size and defendant bias in eyewitness
           identification lineups. \emph{Law and Human Behavior, 5}, 299-309.

           Tredoux, C. G. (1998). Statistical inference on measures of lineup
           fairness. \emph{Law and Human Behavior, 22}(2), 217-237.
}
