% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineup_boot_allprop.R
\name{lineup_boot_allprop}
\alias{lineup_boot_allprop}
\title{Confidence intervals for lineup proportion}
\usage{
lineup_boot_allprop(lineup_vec, k, conf = 0.95)
}
\arguments{
\item{lineup_vec}{A numeric vector of lineup choices}

\item{k}{Number of targets in lineup. Must be specified by user (scalar).}

\item{conf}{Desired level of alpha. Defaults to 0.95. May be specified by user (scalar).}
}
\value{
Returns a vector of bias corrected confidence intervals for
       lineup proportion for each member in a lineup
}
\description{
Computes bootstrapped confidence intervals for lineup proportion
}
\details{
Function that computes bootstrapped lineup proportion using 1000 bootstrap draws
        Calls 'boot function in 'boot' package
}
\examples{
#Data:
lineup_vec <- round(runif(100, 1, 6))

#Call:
lineuprops_ci <- lineup_boot_allprop(lineup_vec, k= 6)
lineuprops_ci <- lineup_boot_allprop(lineup_vec, k= 6, conf = 0.975)

}
\references{
Davison,  A.C. & Hinkley,  D.V. (1997). \emph{Bootstrap methods and their
           application}. Cambridge University Press.

           Wells, G. L., Leippe, M. R., & Ostrom, T. M. (1979). Guidelines for
           assessing the fairness of a lineup. \emph{Law and Human Behavior, 3}(4),
           285-293.
}
\seealso{
\code{\link[boot:boot]{boot}}: https://cran.r-project.org/web/packages/boot/boot.pdf
}
