% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineup_prop_vec.R
\name{lineup_prop_vec}
\alias{lineup_prop_vec}
\title{Lineup proportion}
\usage{
lineup_prop_vec(lineup_vec, target_pos, k)
}
\arguments{
\item{lineup_vec}{A numeric vector of lineup choices}

\item{target_pos}{Suspect/lineup member position. Must be declared by user (scalar).}

\item{k}{Nominal size (i.e., total number of members in lineup). Must be specified by user (scalar).}
}
\value{
Returns a proportion indicating the frequency with which a target was
       identified in a lineup
}
\description{
Computes the proportion of mock witnesses identifying a particular lineup member
}
\examples{
#Data:
lineup_vec <- round(runif(100, 1, 6))

#Call:
lineup_prop_vec(lineup_vec, 3, 6)

}
\references{
Wells, G. L.,Leippe, M. R., & Ostrom, T. M. (1979). Guidelines for
           empirically assessing the fairness of a lineup. \emph{Law and Human Behavior,
           3}(4), 285-293.
}
