% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/windowpane.R
\name{windowpane}
\alias{windowpane}
\title{Window Pane for Epidemiological Analysis}
\usage{
windowpane(
  data,
  end_date_col,
  date_col,
  variable,
  summary_type,
  threshold = NULL,
  window_lengths,
  direction = "backward",
  group_by_cols = NULL,
  date_format = "\%Y-\%m-\%d"
)
}
\arguments{
\item{data}{A data frame containing the input data.}

\item{end_date_col}{A string specifying the name of the column representing the end date.}

\item{date_col}{A string specifying the name of the column representing the date variable.}

\item{variable}{A string specifying the name of the column for which summary statistics are calculated.}

\item{summary_type}{A string specifying the type of summary to calculate. Options are "mean", "sum",
"above_threshold", or "below_threshold".}

\item{threshold}{Optional numeric value used when \code{summary_type} is "above_threshold" or "below_threshold".}

\item{window_lengths}{A numeric vector specifying the window lengths (in days) for the calculations.}

\item{direction}{A string specifying the direction of the window. Options are "backward" (default),
"forward", or "both".}

\item{group_by_cols}{Optional vector of strings specifying column names for grouping the data.}

\item{date_format}{A string specifying the format of the date columns. Default is "\%Y-\%m-\%d".}
}
\value{
A data frame with the calculated summary values for each window.
}
\description{
This function calculates summary statistics within specified windows around a given end date
in a dataset, facilitating epidemiological analysis. It allows backward, forward, or both
directions of window calculations based on a user-defined variable and window lengths.
}
\seealso{
Other Disease modeling: 
\code{\link{get_nasapower}()}
}
\concept{Disease modeling}
