% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/immunogenicity_functions.R
\docType{methods}
\name{scpForestPlot}
\alias{scpForestPlot}
\alias{scpForestPlot,ImmunoAssay-method}
\title{Generate forest plot of SCP values}
\usage{
scpForestPlot(assay.obj, ...)
}
\arguments{
\item{assay.obj}{An ImmunoAssay object imported by importAssay}

\item{...}{Additional arguments for forestplot() function}
}
\value{
A forestplot
}
\description{
This function creates a forest plot of the calculated screening cut points. The scp function must be called prior to this function.
}
\examples{
assay.obj <- importAssay(assay.df = lognormAssay, exp.name = 'Experiment1')
assay.obj <- scp(assay.obj, category = 'Experiment1', distrib = 'normal',
data.transf = TRUE, transf.method = 'log10', rm.out = FALSE)
scpForestPlot(assay.obj)

}
\author{
Emma Gail
}
