% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{frameToRules}
\alias{frameToRules}
\title{Conversion of \code{data.frame} to \code{rules} from \code{arules}}
\usage{
frameToRules(model)
}
\arguments{
\item{model}{\code{data.frame} with rules}
}
\value{
\code{arules} \code{rules} representation
}
\description{
Conversion of \code{data.frame} to \code{rules} from \code{arules}
}
\examples{
library("rCBA")

model <- data.frame("rules" = c("{X=1} => {Y=1}","{X=0} => {Y=0}"),
                    "support" = c(0.5,0.5),
                    "confidence" = c(0.5,0.5),
                    "lift" = c(1.0,1.0))

rules <- rCBA::frameToRules(model)
inspect(rules)

}
