% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/displayTopN.R
\name{displayTopN}
\alias{displayTopN}
\title{Print the top-n rows for each ChEA3 collection}
\usage{
displayTopN(
  results,
  n = 10,
  columns = c("Rank", "TF", "Scaled Rank", "Set_name", "Intersect", "Score",
    "FET p-value", "FDR", "Odds Ratio")
)
}
\arguments{
\item{results}{A named list of data frames (the output of \code{queryChEA3()}).}

\item{n}{Number of rows to show per table (default: 10).}

\item{columns}{Optional character vector of column names to display
(keeps intersection with what's present in each data frame).}
}
\value{
(Invisibly) a named list of data frames, each truncated to the first
\code{n} rows (and \code{columns} if provided).
}
\description{
Print the top-n rows for each ChEA3 collection
}
\examples{
\donttest{
    genes <- c("TP53", "MYC", "STAT3", "FOXO1", "BRCA1")
    results <- queryChEA3(genes, verbose = FALSE)

    # Display top 10 TFs from each collection
    displayTopN(results)

    # Display only top 5 with specific columns
    displayTopN(results, n = 5, columns = c("Rank", "TF", "Score", "FDR"))
}
}
