% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{find_binary_cols}
\alias{find_binary_cols}
\title{Find Binary Columns}
\usage{
find_binary_cols(x, include_logical = FALSE)
}
\arguments{
\item{x}{A data.frame or data.table to search for binary columns.}

\item{include_logical}{Logical. If TRUE, logical columns are also considered binary. Default is FALSE.}
}
\value{
A character vector of column names that are binary, or NULL if none are found.
}
\description{
Identifies columns in a data.frame or data.table that are binary (i.e., contain only two unique values), optionally including logical columns.
}
\examples{
df <- data.frame(a = c(0, 1, 1), b = c(TRUE, FALSE, TRUE), c = c(1, 2, 3))
find_binary_cols(df)
find_binary_cols(df, include_logical = TRUE)
}
