% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qedata_define.R
\name{reclassify}
\alias{reclassify}
\title{Reclassify specified columns in a data.table}
\usage{
reclassify(x, v, ...)
}
\arguments{
\item{x}{A data.table. The data.table containing the columns to be reclassified.}

\item{v}{A function. The function to apply to each specified column for reclassification.}

\item{...}{Additional arguments specifying the names of the columns to be reclassified.}
}
\value{
The modified data.table with specified columns reclassified.
}
\description{
This function reclassifies specified columns of a data.table using a provided function.
}
\examples{
library(data.table)
dt <- data.table(a = 1:5, b = 6:10)
dt <- reclassify(dt, as.qe.code, "a", "b")
}
