# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Calculate Boundary Convexity
#' 
#' Cpp function that calculates convexity of a single feature.
#' 
#' Cpp function that takes in a single feature from the given sf object and calculates raw convexity,
#' convexity index, and sinuosity of that feature. It formats convexity data into a NumericMatrix and outputs
#' it.
#' 
#' @param feature A NumericMatrix that holds the data of one feature from the given sf object.
#' @param windowSize A double describing the diameter of the window used to measure convexity.
#' @param stepSize A double describing the distance between measurements along an arc.
#' @param fid An integer that holds the current feature id.
#' @param rid A string that holds the unique route ID for the current feature.
#' @param filename A string denoting the name of the file you wish to output convexity data to.
#' @param noRID A boolean that denotes whether the given sf object has an RID column.
#' 
#' @return matrix
#' 
#' @keywords internal
CalcBoundaryConvex <- function(feature, windowSize, stepSize, fid, rid, filename = "", noRID = TRUE) {
    .Call(`_rLFT_CalcBoundaryConvex`, feature, windowSize, stepSize, fid, rid, filename, noRID)
}

#' Add M values to given feature
#' 
#' Add measure values to a given linear feature and store them in the m-coordinate of the matrix. Returns
#' the new matrix with added m-values.
#' For more information on m-values and linear referencing see: 
#' \url{http://desktop.arcgis.com/en/arcmap/10.3/guide-books/linear-referencing/what-is-linear-referencing.htm}
#' 
#' @param feature A NumericMatrix that holds the data of a single linear feature taken from a given sf object.
#' 
#' @return matrix
#' 
#' @keywords internal
addM <- function(feature) {
    .Call(`_rLFT_addM`, feature)
}

#' Open a file for output
#' 
#' Opens a file for writing and writes all of the convexity data taken from the given sf object to the given
#' file.
#' 
#' @param filename A string denoting the name of the file you wish to output convexity data to.
#' @param noRID A boolean that denotes whether the given sf object has an RID column.
#' @keywords internal
openOutput <- function(filename, noRID) {
    invisible(.Call(`_rLFT_openOutput`, filename, noRID))
}

#' Creates a list of features that have been skipped over
#'
#' Takes in a vector and pushes the feature ID into the vector
#'
#' @param x A NumericVector to hold all the skipped features
#' @param i ID of the skipped feature
#' @keywords internal
skipFeatureList <- function(x, i) {
    .Call(`_rLFT_skipFeatureList`, x, i)
}

