% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sourceSHAPE.R
\name{defineNeighbours}
\alias{defineNeighbours}
\title{The function will identify the binary string of all possible neighbours to a focal genotype.  It is important when querrying the fitness landscape.}
\usage{
defineNeighbours(func_tmpGenotype, func_tmpDirection,
  func_maxHamming = getOption("shape_max_numMutations"),
  func_sepString = getOption("shape_sepString"),
  func_genomeLength = getOption("shape_genomeLength"))
}
\arguments{
\item{func_tmpGenotype}{This is the binary string of the focal genotype for which we want to define possible neighbours.}

\item{func_tmpDirection}{This is a logical which controls if reversions are allowed (ie: if TRUE sites can revert from mutated to WT)}

\item{func_maxHamming}{The maximum number of sites that could be changed by mutation of the tmp_focalGenotype.
NOTE: At present I've not made the code work for anything other than a value of 1.  So do not update
without updating associated code, where appropriate.}

\item{func_sepString}{This is a character string used to collapse vectors of characters.}

\item{func_genomeLength}{The length of the genomes, or number of mutable sites/positions, being simulated.}
}
\value{
Vector of all the genotypes in the neighbouring mutational space accessible within 1 mutation event
}
\description{
The function will identify the binary string of all possible neighbours to a focal genotype.  It is important when querrying the fitness landscape.
}
\examples{
# If you had some individuals with a genome length of 10 sites, and an
# individual with no mutations, as well as one with a single mutation at
# position 7, each had a mutant.  This would define the possible one step
# mutational neighbours.  I also allow back mutations
defineNeighbours(c(""), func_tmpDirection = FALSE, func_maxHamming = 1,
                 func_sepString = "_", func_genomeLength = 10)
defineNeighbours(c("7"), func_tmpDirection = FALSE, func_maxHamming = 1,
                 func_sepString = "_", func_genomeLength = 10)
#' # Same idea, but if we allow back-mutations (ie: reversions)
defineNeighbours(c("7"), func_tmpDirection = TRUE, func_maxHamming = 1,
                 func_sepString = "_", func_genomeLength = 10)

}
