% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sourceSHAPE.R
\name{extractInfo_focalID}
\alias{extractInfo_focalID}
\title{This is a function to extract genotype/lineage specific information.  This info will be mostly through time style of information
but will also include information about it's line of descent, growth pressures pre-establishment, and population size.}
\usage{
extractInfo_focalID(func_focalID, func_estValue, func_stepsCon,
  func_landscapeCon, func_hoodCon, func_refMatrix, func_subNaming,
  func_genomeLength = getOption("shape_genomeLength"),
  func_max_numMutations = getOption("shape_max_numMutations"),
  func_allow_backMutations = getOption("shape_allow_backMutations"),
  func_descentSep = getOption("shape_string_lineDescent"),
  func_hoodExplore = getOption("shape_const_hoodDepth"),
  func_stringSep = getOption("shape_sepString"))
}
\arguments{
\item{func_focalID}{This is the vector of genotype ID(s) of the focal lineage(s) for which information is to be extracted.}

\item{func_estValue}{This value is used to define the threshold size required for a population before it is considered established.}

\item{func_stepsCon}{This is the filepath to an SQLite database storing information for the stepwise changes of a SHAPE run.}

\item{func_landscapeCon}{This is the filepath to an SQLite database storing information for the complete explored and neighbouring fitness landscape of a SHAPE run.}

\item{func_hoodCon}{This is the filepath to an SQLite database storing information for high priority mutational neighbourhood information}

\item{func_refMatrix}{Is a matrix of a SHAPE run's population demographics at a step in time.  I will be querried for
information regarding a genotype's number of mutations and fitness value.
of genotypes, but is not required but is also required}

\item{func_subNaming}{This is a logical which controls if the tables which report on all genotypes with X mutations should be
forced into a single table or it SHAPE is allowed to split them into multiple tables.}

\item{func_genomeLength}{The number of positions simulated within the individual's genomes.}

\item{func_max_numMutations}{The maximum number of mutations that could occur in a single mutation event -- CAUTION: This should never
be anything other than 1 as per how SHAPE is currently implemented.}

\item{func_allow_backMutations}{This is a logical toggle controlling if reversions are allowed -- meaning loss of mutations.}

\item{func_descentSep}{This is the standard string used to collapse line of descent information.}

\item{func_hoodExplore}{This is an object to control which strains we get deep neighbourhood information for
It should be one of \strong{"none","limited","priority","full"}
setting this higher will cost more and more in post analysis runtime.
NOTE: That use of \strong{limited} requires that you pass a func_refMatrix of expected shape (has a "genotypeID" column)!}

\item{func_stringSep}{A common string separator used to merge information.}
}
\value{
This returns a list object with several pieces of summary information for the focal genotype ID.
}
\description{
This is a function to extract genotype/lineage specific information.  This info will be mostly through time style of information
but will also include information about it's line of descent, growth pressures pre-establishment, and population size.
}
\section{Note}{

There is no example as this cannot work outisde of a runSHAPE call, it requires data produced by the simulation experiment.
}

